/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.select;

import java.awt.GridLayout;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.encog.workbench.dialogs.common.EncogCommonDialog;
import org.encog.workbench.dialogs.common.ValidationException;
import org.encog.workbench.dialogs.select.SelectItem;

public class SelectDialog
extends EncogCommonDialog
implements ListSelectionListener {
    private static final long serialVersionUID = 217379094416842461L;
    private SelectItem selected;
    private DefaultListModel model = new DefaultListModel();
    private JList list = new JList(this.model);
    private JTextArea text = new JTextArea();
    private JScrollPane scroll1 = new JScrollPane(this.list);
    private JScrollPane scroll2 = new JScrollPane(this.text);
    private List<SelectItem> choiceList;

    public SelectDialog(JFrame owner, List<SelectItem> choiceList) {
        super(owner);
        JPanel content = this.getBodyPanel();
        this.choiceList = choiceList;
        this.setSize(500, 250);
        this.setLocation(50, 100);
        this.setTitle("Select");
        content.setLayout(new GridLayout(1, 2));
        content.add(this.scroll1);
        content.add(this.scroll2);
        for (SelectItem item : this.choiceList) {
            this.model.addElement(item.getText());
        }
        this.list.addListSelectionListener(this);
        this.text.setLineWrap(true);
        this.text.setWrapStyleWord(true);
        this.text.setEditable(false);
        this.scroll2.setHorizontalScrollBarPolicy(31);
    }

    public SelectItem getSelected() {
        return this.selected;
    }

    @Override
    public void collectFields() throws ValidationException {
        int index = this.list.getSelectedIndex();
        this.selected = index >= 0 ? this.choiceList.get(index) : null;
    }

    @Override
    public void setFields() {
        this.list.setSelectedIndex(0);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int index = this.list.getSelectedIndex();
        if (index != -1) {
            String desc = this.choiceList.get(index).getDescription();
            this.text.setText(desc);
            this.text.setSelectionStart(0);
            this.text.setSelectionEnd(0);
        }
    }
}

