/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.population.epl;

import java.io.File;
import java.util.List;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.buffer.BufferedMLDataSet;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.dialogs.common.CheckField;
import org.encog.workbench.dialogs.common.ComboBoxField;
import org.encog.workbench.dialogs.common.EncogPropertiesDialog;
import org.encog.workbench.frames.document.tree.ProjectTraining;

public class RescoreDialog
extends EncogPropertiesDialog {
    private ComboBoxField comboTraining;
    private final CheckField loadToMemory;
    private static final long serialVersionUID = 3506669325409959724L;
    private List<ProjectTraining> trainingSets;

    public RescoreDialog() {
        super(EncogWorkBench.getInstance().getMainWindow());
        this.findData();
        this.setTitle("Rescore Population");
        this.setSize(400, 400);
        this.setLocation(200, 200);
        this.comboTraining = new ComboBoxField("training set", "Training Set", true, this.trainingSets);
        this.addProperty(this.comboTraining);
        this.loadToMemory = new CheckField("load to memory", "Load to Memory (better performance)");
        this.addProperty(this.loadToMemory);
        this.render();
        this.loadToMemory.setValue(true);
    }

    private void findData() {
        this.trainingSets = EncogWorkBench.getInstance().getTrainingData();
    }

    public MLDataSet getTrainingSet() {
        if (this.getComboTraining().getSelectedValue() == null) {
            return null;
        }
        File file = ((ProjectTraining)this.getComboTraining().getSelectedValue()).getFile();
        BufferedMLDataSet result = new BufferedMLDataSet(file);
        if (this.loadToMemory.getValue()) {
            return result.loadToMemory();
        }
        return result;
    }

    public ComboBoxField getComboTraining() {
        return this.comboTraining;
    }

    public List<ProjectTraining> getTrainingSets() {
        return this.trainingSets;
    }
}

