/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.createnetwork;

import java.awt.Frame;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.dialogs.activation.ActivationDialog;
import org.encog.workbench.dialogs.common.BuildingListField;
import org.encog.workbench.dialogs.common.BuildingListListener;
import org.encog.workbench.dialogs.common.EncogPropertiesDialog;
import org.encog.workbench.dialogs.common.IntegerField;
import org.encog.workbench.dialogs.common.PopupField;
import org.encog.workbench.dialogs.common.PopupListener;

public class CreateFeedforward
extends EncogPropertiesDialog
implements BuildingListListener,
PopupListener {
    private IntegerField inputCount;
    private IntegerField outputCount;
    private BuildingListField hidden;
    private PopupField activationFieldHidden;
    private PopupField activationFieldOutput;
    private ActivationFunction activationFunctionHidden;
    private ActivationFunction activationFunctionOutput;

    public CreateFeedforward(Frame owner) {
        super(owner);
        this.setTitle("Create Feedforward Network");
        this.setSize(600, 400);
        this.setLocation(200, 200);
        this.inputCount = new IntegerField("input neurons", "Input Neuron Count", true, 1, 100000);
        this.addProperty(this.inputCount);
        this.hidden = new BuildingListField("hidden neurons", "Hidden Layer Counts");
        this.addProperty(this.hidden);
        this.outputCount = new IntegerField("output neurons", "Output Neuron Count", true, 1, 100000);
        this.addProperty(this.outputCount);
        this.activationFieldHidden = new PopupField("activation hidden", "Activation Function Hidden", true);
        this.addProperty(this.activationFieldHidden);
        this.activationFieldOutput = new PopupField("activation output", "Activation Function Output", true);
        this.addProperty(this.activationFieldOutput);
        this.render();
    }

    public IntegerField getInputCount() {
        return this.inputCount;
    }

    public IntegerField getOutputCount() {
        return this.outputCount;
    }

    private String askNeurons(int layer) {
        String str = EncogWorkBench.displayInput("How many neurons for hidden layer " + layer + "?");
        if (str == null) {
            return null;
        }
        try {
            str = "Hidden Layer " + layer + ": " + Integer.parseInt(str.trim()) + " neurons";
        }
        catch (NumberFormatException e) {
            EncogWorkBench.displayError("Error", "Enter a valid number.");
            return null;
        }
        return str;
    }

    @Override
    public void add(BuildingListField list, int index) {
        String str = this.askNeurons(list.getModel().size() + 1);
        if (str != null) {
            list.getModel().addElement(str);
        }
    }

    @Override
    public void del(BuildingListField list, int index) {
        if (index != -1) {
            list.getModel().remove(index);
        }
    }

    @Override
    public void edit(BuildingListField list, int index) {
        String str;
        if (index != -1 && (str = this.askNeurons(index + 1)) != null) {
            list.getModel().remove(index);
            list.getModel().add(index, str);
        }
    }

    public BuildingListField getHidden() {
        return this.hidden;
    }

    @Override
    public String popup(PopupField field) {
        ActivationDialog dialog = new ActivationDialog(EncogWorkBench.getInstance().getMainWindow());
        if (field == this.activationFieldHidden) {
            dialog.setActivation(this.activationFunctionHidden);
        } else if (field == this.activationFieldOutput) {
            dialog.setActivation(this.activationFunctionOutput);
        }
        if (!dialog.process()) {
            return null;
        }
        if (field == this.activationFieldHidden) {
            this.activationFunctionHidden = dialog.getActivation();
            return dialog.getActivation().getClass().getSimpleName();
        }
        if (field == this.activationFieldOutput) {
            this.activationFunctionOutput = dialog.getActivation();
            return dialog.getActivation().getClass().getSimpleName();
        }
        return null;
    }

    public PopupField getActivationHiddenField() {
        return this.activationFieldHidden;
    }

    public ActivationFunction getActivationFunctionHidden() {
        return this.activationFunctionHidden;
    }

    public void setActivationFunctionHidden(ActivationFunction activationFunction) {
        this.activationFunctionHidden = activationFunction;
        this.activationFieldHidden.setValue(this.activationFunctionHidden.getClass().getSimpleName());
    }

    public ActivationFunction getActivationFunctionOutput() {
        return this.activationFunctionOutput;
    }

    public void setActivationFunctionOutput(ActivationFunction activationFunction) {
        this.activationFunctionOutput = activationFunction;
        this.activationFieldOutput.setValue(this.activationFunctionOutput.getClass().getSimpleName());
    }
}

