/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.config;

import java.awt.Frame;
import java.util.ArrayList;
import org.encog.workbench.dialogs.common.CheckField;
import org.encog.workbench.dialogs.common.ComboBoxField;
import org.encog.workbench.dialogs.common.DoubleField;
import org.encog.workbench.dialogs.common.EncogPropertiesDialog;
import org.encog.workbench.dialogs.common.FolderField;
import org.encog.workbench.dialogs.common.IntegerField;

public class EncogConfigDialog
extends EncogPropertiesDialog {
    private DoubleField defaultError;
    private IntegerField threadCount;
    private CheckField useOpenCL;
    private ComboBoxField errorCalculation;
    private IntegerField trainingChartHistory;
    private IntegerField iterationStepCount;
    private CheckField displayTrainingImprovement;
    private CheckField allowConnections;
    private IntegerField port;
    private FolderField rootDirectory;

    public EncogConfigDialog(Frame owner) {
        super(owner);
        ArrayList<String> errorMethods = new ArrayList<String>();
        errorMethods.add("Root Mean Square");
        errorMethods.add("Mean Square Error");
        this.setTitle("Encog Configuration");
        this.setSize(500, 300);
        this.beginTab("Training");
        this.defaultError = new DoubleField("default error", "Default Error Percent", true, 0, 100);
        this.addProperty(this.defaultError);
        this.errorCalculation = new ComboBoxField("error calculation", "Error Calculation", true, errorMethods);
        this.addProperty(this.errorCalculation);
        this.threadCount = new IntegerField("thread count", "Thread Count (0=auto)", true, 0, 10000);
        this.addProperty(this.threadCount);
        this.trainingChartHistory = new IntegerField("training historycount", "Training Chart History (-1 = infinite)", true, -1, Integer.MAX_VALUE);
        this.addProperty(this.trainingChartHistory);
        this.iterationStepCount = new IntegerField("step count", "Iteration Step Count", true, 1, 1000);
        this.addProperty(this.iterationStepCount);
        this.displayTrainingImprovement = new CheckField("show improvement", "Show Training Improvement");
        this.addProperty(this.displayTrainingImprovement);
        this.beginTab("Indicator");
        this.allowConnections = new CheckField("open server", "Allow Connections");
        this.addProperty(this.allowConnections);
        this.port = new IntegerField("server port", "Server Port", true, 1, 60000);
        this.addProperty(this.port);
        this.beginTab("Paths");
        this.rootDirectory = new FolderField("root dir", "Root Project Path", true);
        this.addProperty(this.rootDirectory);
        this.render();
    }

    public DoubleField getDefaultError() {
        return this.defaultError;
    }

    public IntegerField getThreadCount() {
        return this.threadCount;
    }

    public ComboBoxField getErrorCalculation() {
        return this.errorCalculation;
    }

    public IntegerField getTrainingChartHistory() {
        return this.trainingChartHistory;
    }

    public IntegerField getIterationStepCount() {
        return this.iterationStepCount;
    }

    public CheckField getDisplayTrainingImprovement() {
        return this.displayTrainingImprovement;
    }

    public FolderField getRootDirectory() {
        return this.rootDirectory;
    }

    public CheckField getAllowConnections() {
        return this.allowConnections;
    }

    public IntegerField getPort() {
        return this.port;
    }
}

