/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.common;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class TableFieldModel
implements TableModel {
    private final List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private Object[][] data;
    private Class<?> type;
    private String[] heads;
    private boolean[] editable;

    public TableFieldModel(Class<?> c, int rows, int columns) {
        this.type = c;
        this.data = new Object[rows][columns];
        this.editable = new boolean[columns];
        int i = 0;
        while (i < this.editable.length) {
            this.editable[i] = true;
            ++i;
        }
    }

    public TableFieldModel(Class<?> c, String[] heads, int rows) {
        this.type = c;
        this.data = new Object[rows][heads.length];
        this.heads = heads;
        this.editable = new boolean[heads.length];
        int i = 0;
        while (i < this.editable.length) {
            this.editable[i] = true;
            ++i;
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.type;
    }

    @Override
    public int getColumnCount() {
        return this.data[0].length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (this.heads != null) {
            return this.heads[columnIndex];
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.data[rowIndex][columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.editable[columnIndex];
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        this.data[rowIndex][columnIndex] = value;
    }

    public void setEditable(int index, boolean b) {
        this.editable[index] = b;
    }
}

