/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.common;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.encog.workbench.dialogs.common.BuildingListListener;
import org.encog.workbench.dialogs.common.PropertiesField;
import org.encog.workbench.dialogs.common.ValidationException;

public class BuildingListField
extends PropertiesField
implements ActionListener {
    private JList list;
    private JButton btnAdd;
    private JButton btnDelete;
    private JButton btnEdit;
    private DefaultListModel model;
    private int height;

    public BuildingListField(String name, String label, int height) {
        super(name, label, true);
        this.height = height;
    }

    public BuildingListField(String name, String label) {
        this(name, label, 100);
    }

    @Override
    public void collect() throws ValidationException {
    }

    @Override
    public int createField(JPanel panel, int x, int y, int width) {
        JLabel label = this.createLabel();
        label.setLocation(label.getX(), y);
        this.setField(new JPanel());
        this.getField().setLocation(x, y);
        this.getField().setSize(width, this.height);
        panel.add(this.createLabel());
        panel.add(this.getField());
        this.model = new DefaultListModel();
        this.getField().setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.getField().setLayout(new BorderLayout());
        this.list = new JList(this.model);
        JScrollPane scroll = new JScrollPane(this.list);
        this.getField().add((Component)scroll, "Center");
        JPanel buttons = new JPanel();
        this.getField().add((Component)buttons, "South");
        buttons.setLayout(new GridLayout(1, 4));
        this.btnAdd = new JButton("Add");
        buttons.add(this.btnAdd);
        this.btnDelete = new JButton("Remove");
        buttons.add(this.btnDelete);
        this.btnEdit = new JButton("Edit");
        buttons.add(this.btnEdit);
        this.btnAdd.addActionListener(this);
        this.btnEdit.addActionListener(this);
        this.btnDelete.addActionListener(this);
        return y += 100;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.btnAdd == e.getSource()) {
            ((BuildingListListener)((Object)this.getOwner())).add(this, this.list.getSelectedIndex());
        } else if (this.btnDelete == e.getSource()) {
            ((BuildingListListener)((Object)this.getOwner())).del(this, this.list.getSelectedIndex());
        } else if (this.btnEdit == e.getSource()) {
            ((BuildingListListener)((Object)this.getOwner())).edit(this, this.list.getSelectedIndex());
        }
    }

    public DefaultListModel getModel() {
        return this.model;
    }
}

