/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.activation;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Stroke;
import javax.swing.JPanel;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationSigmoid;
import org.encog.workbench.dialogs.activation.ActivationFunction2D;
import org.encog.workbench.dialogs.activation.DerivativeFunction2D;
import org.encog.workbench.util.graph.EncogChartPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.function.Function2D;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class EquationPanel
extends JPanel {
    private ChartPanel panel;

    public EquationPanel() {
        this.setLayout(new BorderLayout());
        this.setupEquation(new ActivationSigmoid(), true);
    }

    public void setupEquation(ActivationFunction activation, boolean normal) {
        JFreeChart chart = EquationPanel.createChart(EquationPanel.createDataset(activation, normal), activation, normal);
        if (this.panel == null) {
            this.panel = new EncogChartPanel(chart);
            this.panel.setMouseWheelEnabled(true);
            this.add((Component)this.panel, "Center");
        } else {
            this.panel.setChart(chart);
        }
    }

    public static XYDataset createDataset(ActivationFunction activation, boolean normal) {
        XYSeriesCollection dataset = new XYSeriesCollection();
        if (normal) {
            ActivationFunction2D n1 = new ActivationFunction2D(activation);
            XYSeries s1 = DatasetUtilities.sampleFunction2DToSeries((Function2D)n1, (double)-5.1, (double)5.1, (int)121, (Comparable)((Object)"Activation Function"));
            dataset.addSeries(s1);
        } else if (activation.hasDerivative()) {
            DerivativeFunction2D n2 = new DerivativeFunction2D(activation);
            XYSeries s2 = DatasetUtilities.sampleFunction2DToSeries((Function2D)n2, (double)-5.1, (double)5.1, (int)121, (Comparable)((Object)"Derivative Function"));
            dataset.addSeries(s2);
        }
        return dataset;
    }

    public static JFreeChart createChart(XYDataset dataset, ActivationFunction activation, boolean normal) {
        String title = normal ? activation.getClass().getSimpleName() : (activation.hasDerivative() ? "Derv of " + activation.getClass().getSimpleName() : "NO Derv of " + activation.getClass().getSimpleName());
        JFreeChart chart = ChartFactory.createXYLineChart((String)title, (String)"input (x)", (String)"output (y)", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = (XYPlot)chart.getPlot();
        if (normal) {
            plot.setDomainZeroBaselineVisible(true);
            plot.setRangeZeroBaselineVisible(true);
            plot.setDomainPannable(true);
            plot.setRangePannable(true);
            ValueAxis xAxis = plot.getDomainAxis();
            xAxis.setLowerMargin(0.0);
            xAxis.setUpperMargin(0.0);
            XYLineAndShapeRenderer r = (XYLineAndShapeRenderer)plot.getRenderer();
            r.setDrawSeriesLineAsPath(true);
            r.setSeriesStroke(0, (Stroke)new BasicStroke(1.5f));
            r.setSeriesStroke(1, (Stroke)new BasicStroke(2.0f, 1, 1, 1.0f, new float[]{6.0f, 4.0f}, 0.0f));
            r.setSeriesStroke(2, (Stroke)new BasicStroke(2.0f, 1, 1, 1.0f, new float[]{6.0f, 4.0f, 3.0f, 3.0f}, 0.0f));
            r.setSeriesStroke(3, (Stroke)new BasicStroke(2.0f, 1, 1, 1.0f, new float[]{4.0f, 4.0f}, 0.0f));
        }
        return chart;
    }
}

