/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench;

import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JOptionPane;
import org.encog.Encog;
import org.encog.EncogError;
import org.encog.mathutil.error.ErrorCalculation;
import org.encog.ml.MLMethod;
import org.encog.ml.data.MLDataSet;
import org.encog.neural.neat.NEATPopulation;
import org.encog.persist.EncogDirectoryPersistence;
import org.encog.util.concurrency.MultiThreadable;
import org.encog.util.obj.ReflectionUtil;
import org.encog.workbench.WorkbenchLogging;
import org.encog.workbench.config.EncogWorkBenchConfig;
import org.encog.workbench.dialogs.error.ErrorDialog;
import org.encog.workbench.frames.document.EncogDocumentFrame;
import org.encog.workbench.frames.document.EncogOutputPanel;
import org.encog.workbench.frames.document.tree.ProjectEGFile;
import org.encog.workbench.frames.document.tree.ProjectFile;
import org.encog.workbench.frames.document.tree.ProjectItem;
import org.encog.workbench.frames.document.tree.ProjectTraining;
import org.encog.workbench.util.FileUtil;
import org.encog.workbench.util.WorkbenchLogHandler;

public class EncogWorkBench
implements Runnable {
    public static final String CONFIG_FILENAME = ".EncogWorkbench.conf";
    public static final String VERSION = "3.4";
    public static final String COPYRIGHT = "Copyright 2016 by Heaton Research, Inc.";
    private static EncogWorkBench instance;
    private EncogDocumentFrame mainWindow;
    private EncogWorkBenchConfig config = new EncogWorkBenchConfig();
    private WorkbenchLogHandler logHandler = new WorkbenchLogHandler();
    private String currentFileName;

    public static boolean askQuestion(String title, String question) {
        return JOptionPane.showConfirmDialog(null, question, title, 0) == 0;
    }

    public static void displayError(String title, String message) {
        JOptionPane.showMessageDialog(null, message, title, 0);
    }

    public static void displayMessage(String title, String message) {
        JOptionPane.showMessageDialog(null, message, title, 1);
    }

    public static Frame getCurrentFocus() {
        Frame[] frames = Frame.getFrames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].hasFocus()) {
                return frames[i];
            }
            ++i;
        }
        return null;
    }

    public static EncogWorkBench getInstance() {
        if (instance == null) {
            instance = new EncogWorkBench();
        }
        return instance;
    }

    public EncogDocumentFrame getMainWindow() {
        return this.mainWindow;
    }

    public void setCurrentFileName(String currentFileName) {
        this.currentFileName = currentFileName;
    }

    public void setMainWindow(EncogDocumentFrame mainWindow) {
        this.mainWindow = mainWindow;
    }

    public static String displayInput(String prompt) {
        return JOptionPane.showInputDialog(null, prompt, "");
    }

    public EncogWorkBenchConfig getConfig() {
        return this.config;
    }

    public static boolean displayQuery(String title, String message) {
        int result = JOptionPane.showConfirmDialog(null, message, title, 0);
        EncogWorkBench.getInstance().getMainWindow().endWait();
        return result == 0;
    }

    public static void displayError(String title, Throwable t, ProjectFile network, MLDataSet set) {
        if (t instanceof EncogError) {
            EncogWorkBench.displayError(title, "An error occured while performing this operation:\n" + t.toString());
            t.printStackTrace();
        } else if (t instanceof OutOfMemoryError) {
            EncogWorkBench.displayError(title, "Not enough memory to do that.");
            t.printStackTrace();
        } else {
            ErrorDialog.handleError(t, network, set);
        }
    }

    public static void displayError(String title, Throwable t) {
        EncogWorkBench.displayError(title, t, null, null);
        EncogWorkBench.getInstance().getMainWindow().endWait();
    }

    @Override
    public void run() {
        try {
            while (true) {
                Thread.sleep(300000L);
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public void init() {
        Encog.getInstance().registerPlugin(new WorkbenchLogging());
        EncogWorkBench.getInstance().getConfig().loadConfig();
        if (EncogWorkBench.getInstance().getConfig().isUseOpenCL()) {
            EncogWorkBench.initCL();
        }
        ErrorCalculation.setMode(EncogWorkBench.getInstance().getConfig().getErrorCalculation());
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }

    public static void main(String[] args) {
        Encog.getInstance();
        if (Encog.isOSX()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("apple.awt.brushMetalLook", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Encog Workbench");
            System.setProperty("apple.eawt.quitStrategy", "CLOSE_ALL_WINDOWS");
        }
        EncogWorkBench workBench = EncogWorkBench.getInstance();
        workBench.setMainWindow(new EncogDocumentFrame());
        workBench.init();
        try {
            workBench.getMainWindow().setVisible(true);
        }
        catch (Throwable t) {
            EncogWorkBench.displayError("Internal error", t.getMessage());
            t.printStackTrace();
        }
    }

    public static void initCL() {
    }

    public void clearOutput() {
        this.getMainWindow().getOutputPane().clear();
    }

    public void output(String str) {
        EncogOutputPanel pane = this.getMainWindow().getOutputPane();
        if (pane != null) {
            pane.output(str);
        }
    }

    public void outputLine(String str) {
        EncogOutputPanel pane = this.getMainWindow().getOutputPane();
        if (pane != null) {
            pane.outputLine(str);
        }
    }

    public WorkbenchLogHandler getLogHandler() {
        return this.logHandler;
    }

    public File getEncogFolders() {
        if (this.config.getProjectRoot() == null || this.config.getProjectRoot().trim().length() == 0) {
            return EncogWorkBenchConfig.getDefaultProjectRoot();
        }
        return new File(this.config.getProjectRoot());
    }

    public List<ProjectTraining> getTrainingData() {
        ArrayList<ProjectTraining> result = new ArrayList<ProjectTraining>();
        for (ProjectItem item : this.getMainWindow().getTree().getModel().getData()) {
            if (!(item instanceof ProjectTraining)) continue;
            result.add((ProjectTraining)item);
        }
        return result;
    }

    public List<ProjectFile> getAnalystFiles() {
        ArrayList<ProjectFile> result = new ArrayList<ProjectFile>();
        for (ProjectItem item : this.getMainWindow().getTree().getModel().getData()) {
            ProjectFile pf;
            if (!(item instanceof ProjectFile) || !(pf = (ProjectFile)item).getExtension().equalsIgnoreCase("ega")) continue;
            result.add((ProjectFile)item);
        }
        return result;
    }

    public File getProjectDirectory() {
        return this.getMainWindow().getTree().getModel().getPath();
    }

    public void refresh() {
        this.getMainWindow().getTree().refresh();
    }

    public void save(File path, Object network) {
        EncogDirectoryPersistence.saveObject(path, network);
        this.refresh();
    }

    public EncogDirectoryPersistence getProject() {
        return this.getMainWindow().getTree().getModel().getProjectDirectory();
    }

    public List<ProjectEGFile> getMLMethods(boolean includePop) {
        ArrayList<ProjectEGFile> result = new ArrayList<ProjectEGFile>();
        for (ProjectItem item : this.getMainWindow().getTree().getModel().getData()) {
            ProjectEGFile item2;
            Class<?> clazz;
            if (!(item instanceof ProjectEGFile) || (clazz = ReflectionUtil.resolveEncogClass((item2 = (ProjectEGFile)item).getEncogType())) == null) continue;
            if (MLMethod.class.isAssignableFrom(clazz)) {
                result.add(item2);
                continue;
            }
            if (!NEATPopulation.class.isAssignableFrom(clazz) || !includePop) continue;
            result.add(item2);
        }
        return result;
    }

    public void setupThreads(Object obj) {
        if (obj instanceof MultiThreadable) {
            MultiThreadable threadable = (MultiThreadable)obj;
            int threads = this.config.getThreadCount();
            threadable.setThreadCount(threads);
        }
    }

    public List<ProjectEGFile> getNEATPopulations() {
        ArrayList<ProjectEGFile> result = new ArrayList<ProjectEGFile>();
        for (ProjectItem item : this.getMainWindow().getTree().getModel().getData()) {
            ProjectEGFile item2;
            Class<?> clazz;
            if (!(item instanceof ProjectEGFile) || !NEATPopulation.class.isAssignableFrom(clazz = ReflectionUtil.resolveEncogClass((item2 = (ProjectEGFile)item).getEncogType()))) continue;
            result.add(item2);
        }
        return result;
    }

    public static String displayInput(String prompt, String str) {
        return JOptionPane.showInputDialog(null, prompt, str);
    }

    public List<ProjectTraining> getTrainingData(final String sortFirst) {
        List<ProjectTraining> list = this.getTrainingData();
        Collections.sort(list, new Comparator<ProjectTraining>(){

            @Override
            public int compare(ProjectTraining p1, ProjectTraining p2) {
                boolean isFirst1 = FileUtil.getFileName(p1.getFile()).endsWith(sortFirst);
                boolean isFirst2 = FileUtil.getFileName(p2.getFile()).endsWith(sortFirst);
                if (isFirst1 && !isFirst2) {
                    return -1;
                }
                if (isFirst2 && !isFirst1) {
                    return 1;
                }
                return p1.getName().compareTo(p2.getName());
            }
        });
        return list;
    }
}

