/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.simple;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.encog.EncogError;
import org.encog.app.analyst.csv.basic.BasicFile;
import org.encog.engine.network.activation.ActivationSigmoid;
import org.encog.engine.network.activation.ActivationTANH;
import org.encog.mathutil.error.ErrorCalculation;
import org.encog.mathutil.randomize.generate.GenerateRandom;
import org.encog.ml.MLClassification;
import org.encog.ml.MLContext;
import org.encog.ml.MLMethod;
import org.encog.ml.MLRegression;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.ml.data.basic.BasicMLDataSet;
import org.encog.ml.data.buffer.BufferedMLDataSet;
import org.encog.ml.data.buffer.MemoryDataLoader;
import org.encog.ml.data.buffer.codec.CSVDataCODEC;
import org.encog.ml.data.specific.CSVNeuralDataSet;
import org.encog.ml.data.versatile.MatrixMLDataSet;
import org.encog.ml.svm.SVM;
import org.encog.ml.svm.training.SVMTrain;
import org.encog.ml.train.BasicTraining;
import org.encog.ml.train.MLTrain;
import org.encog.neural.freeform.FreeformNetwork;
import org.encog.neural.freeform.training.FreeformResilientPropagation;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.ContainsFlat;
import org.encog.neural.networks.training.propagation.resilient.ResilientPropagation;
import org.encog.neural.pattern.FeedForwardPattern;
import org.encog.util.Format;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;
import org.encog.util.logging.EncogLogging;

public final class EncogUtility {
    public static void convertCSV2Binary(File csvFile, File binFile, int inputCount, int outputCount, boolean headers) {
        binFile.delete();
        CSVNeuralDataSet csv = new CSVNeuralDataSet(csvFile.toString(), inputCount, outputCount, false);
        BufferedMLDataSet buffer = new BufferedMLDataSet(binFile);
        buffer.beginLoad(inputCount, outputCount);
        for (MLDataPair pair : csv) {
            buffer.add(pair);
        }
        buffer.endLoad();
    }

    public static MLDataSet loadCSV2Memory(String filename, int input, int ideal, boolean headers, CSVFormat format, boolean significance) {
        CSVDataCODEC codec = new CSVDataCODEC(new File(filename), format, headers, input, ideal, significance);
        MemoryDataLoader load = new MemoryDataLoader(codec);
        MLDataSet dataset = load.external2Memory();
        return dataset;
    }

    public static void evaluate(MLRegression network, MLDataSet training) {
        for (MLDataPair pair : training) {
            MLData output = network.compute(pair.getInput());
            System.out.println("Input=" + EncogUtility.formatNeuralData(pair.getInput()) + ", Actual=" + EncogUtility.formatNeuralData(output) + ", Ideal=" + EncogUtility.formatNeuralData(pair.getIdeal()));
        }
    }

    public static String formatNeuralData(MLData data) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < data.size()) {
            if (i != 0) {
                result.append(',');
            }
            result.append(Format.formatDouble(data.getData(i), 4));
            ++i;
        }
        return result.toString();
    }

    public static BasicNetwork simpleFeedForward(int input, int hidden1, int hidden2, int output, boolean tanh) {
        FeedForwardPattern pattern = new FeedForwardPattern();
        pattern.setInputNeurons(input);
        pattern.setOutputNeurons(output);
        if (tanh) {
            pattern.setActivationFunction(new ActivationTANH());
        } else {
            pattern.setActivationFunction(new ActivationSigmoid());
        }
        if (hidden1 > 0) {
            pattern.addHiddenLayer(hidden1);
        }
        if (hidden2 > 0) {
            pattern.addHiddenLayer(hidden2);
        }
        BasicNetwork network = (BasicNetwork)pattern.generate();
        network.reset();
        return network;
    }

    public static void trainConsole(BasicNetwork network, MLDataSet trainingSet, int minutes) {
        ResilientPropagation train = new ResilientPropagation(network, trainingSet);
        train.setThreadCount(0);
        EncogUtility.trainConsole(train, network, trainingSet, minutes);
    }

    public static void trainConsole(MLTrain train, BasicNetwork network, MLDataSet trainingSet, int minutes) {
        long remaining;
        System.out.println("Beginning training...");
        long start = System.currentTimeMillis();
        do {
            train.iteration();
            long current = System.currentTimeMillis();
            long elapsed = (current - start) / 1000L;
            remaining = (long)(minutes * 60) - elapsed;
            int iteration = train.getIteration();
            System.out.println("Iteration #" + Format.formatInteger(iteration) + " Error:" + Format.formatPercent(train.getError()) + " elapsed time = " + Format.formatTimeSpan((int)elapsed) + " time left = " + Format.formatTimeSpan((int)remaining));
        } while (remaining > 0L);
        train.finishTraining();
    }

    public static void trainToError(MLMethod method, MLDataSet dataSet, double error) {
        if (method instanceof SVM) {
            SVMTrain sVMTrain = new SVMTrain((SVM)method, dataSet);
        }
        BasicTraining train = method instanceof FreeformNetwork ? new FreeformResilientPropagation((FreeformNetwork)method, dataSet) : new ResilientPropagation((ContainsFlat)method, dataSet);
        EncogUtility.trainToError(train, error);
    }

    public static void trainToError(MLTrain train, double error) {
        int epoch = 1;
        System.out.println("Beginning training...");
        do {
            train.iteration();
            System.out.println("Iteration #" + Format.formatInteger(epoch) + " Error:" + Format.formatPercent(train.getError()) + " Target Error: " + Format.formatPercent(error));
            ++epoch;
        } while (train.getError() > error && !train.isTrainingDone());
        train.finishTraining();
    }

    private EncogUtility() {
    }

    public static MLDataSet loadEGB2Memory(File filename) {
        BufferedMLDataSet buffer = new BufferedMLDataSet(filename);
        MLDataSet result = buffer.loadToMemory();
        buffer.close();
        return result;
    }

    public static void convertCSV2Binary(String csvFile, String binFile, int inputCount, int outputCount, boolean headers) {
        new File(binFile).delete();
        CSVNeuralDataSet csv = new CSVNeuralDataSet(csvFile.toString(), inputCount, outputCount, headers);
        BufferedMLDataSet buffer = new BufferedMLDataSet(new File(binFile));
        buffer.beginLoad(inputCount, outputCount);
        for (MLDataPair pair : csv) {
            buffer.add(pair);
        }
        buffer.endLoad();
    }

    public static void convertCSV2Binary(File csvFile, CSVFormat format, File binFile, int[] input, int[] ideal, boolean headers) {
        binFile.delete();
        ReadCSV csv = new ReadCSV(csvFile.toString(), headers, format);
        BufferedMLDataSet buffer = new BufferedMLDataSet(binFile);
        buffer.beginLoad(input.length, ideal.length);
        while (csv.next()) {
            BasicMLData inputData = new BasicMLData(input.length);
            BasicMLData idealData = new BasicMLData(ideal.length);
            int i = 0;
            while (i < input.length) {
                inputData.setData(i, csv.getDouble(input[i]));
                ++i;
            }
            i = 0;
            while (i < ideal.length) {
                idealData.setData(i, csv.getDouble(ideal[i]));
                ++i;
            }
            buffer.add(inputData, idealData);
        }
        buffer.endLoad();
    }

    public static double calculateRegressionError(MLRegression method, MLDataSet data) {
        ErrorCalculation errorCalculation = new ErrorCalculation();
        if (method instanceof MLContext) {
            ((MLContext)((Object)method)).clearContext();
        }
        try {
            for (MLDataPair pair : data) {
                MLData actual = method.compute(pair.getInput());
                errorCalculation.updateError(actual.getData(), pair.getIdeal().getData(), pair.getSignificance());
            }
        }
        catch (EncogError e) {
            return Double.NaN;
        }
        return errorCalculation.calculate();
    }

    public static void saveCSV(File targetFile, CSVFormat format, MLDataSet set) {
        FileWriter outFile = null;
        PrintWriter out = null;
        try {
            try {
                outFile = new FileWriter(targetFile);
                out = new PrintWriter(outFile);
                for (MLDataPair data : set) {
                    double d;
                    StringBuilder line = new StringBuilder();
                    int i = 0;
                    while (i < data.getInput().size()) {
                        d = data.getInput().getData(i);
                        BasicFile.appendSeparator(line, format);
                        line.append(format.format(d, 10));
                        ++i;
                    }
                    i = 0;
                    while (i < data.getIdeal().size()) {
                        d = data.getIdeal().getData(i);
                        BasicFile.appendSeparator(line, format);
                        line.append(format.format(d, 10));
                        ++i;
                    }
                    out.println(line);
                }
            }
            catch (IOException ex) {
                throw new EncogError(ex);
            }
        }
        finally {
            if (outFile != null) {
                try {
                    outFile.close();
                }
                catch (IOException e) {
                    EncogLogging.log(e);
                }
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static double calculateClassificationError(MLClassification method, MLDataSet data) {
        int total = 0;
        int correct = 0;
        for (MLDataPair pair : data) {
            int ideal = (int)pair.getIdeal().getData(0);
            int actual = method.classify(pair.getInput());
            if (actual == ideal) {
                ++correct;
            }
            ++total;
        }
        return (double)(total - correct) / (double)total;
    }

    public static void saveEGB(File f, MLDataSet data) {
        BufferedMLDataSet binary = new BufferedMLDataSet(f);
        binary.load(data);
        data.close();
    }

    public static void explainErrorMSE(MLRegression method, MatrixMLDataSet training) {
        StringBuilder line = new StringBuilder();
        double sum = 0.0;
        int count = 0;
        int itemNum = 0;
        for (MLDataPair pair : training) {
            MLData output = method.compute(pair.getInput());
            double dsum = 0.0;
            int i = 0;
            while (i < output.size()) {
                double diff = output.getData()[i] - pair.getIdeal().getData(i);
                dsum += diff * diff;
                ++count;
                ++i;
            }
            sum += dsum;
            line.setLength(0);
            line.append("Item #");
            line.append(itemNum++);
            line.append(", Actual=");
            line.append(EncogUtility.formatNeuralData(output));
            line.append(", Ideal=");
            line.append(EncogUtility.formatNeuralData(pair.getIdeal()));
            line.append(", Delta=");
            line.append(Format.formatDouble(dsum, 4));
            line.append(", Count=");
            line.append(count);
            line.append(", MSE=");
            line.append(Format.formatDouble(sum / (double)count, 4));
            System.out.println(line.toString());
        }
    }

    public static void explainErrorRMS(MLRegression method, MatrixMLDataSet training) {
        StringBuilder line = new StringBuilder();
        double sum = 0.0;
        int count = 0;
        int itemNum = 0;
        for (MLDataPair pair : training) {
            MLData output = method.compute(pair.getInput());
            double dsum = 0.0;
            int i = 0;
            while (i < output.size()) {
                double diff = output.getData()[i] - pair.getIdeal().getData(i);
                dsum += diff * diff;
                ++count;
                ++i;
            }
            sum += dsum;
            line.setLength(0);
            line.append("Item #");
            line.append(itemNum++);
            line.append(", Actual=");
            line.append(EncogUtility.formatNeuralData(output));
            line.append(", Ideal=");
            line.append(EncogUtility.formatNeuralData(pair.getIdeal()));
            line.append(", Delta=");
            line.append(Format.formatDouble(dsum, 4));
            line.append(", Count=");
            line.append(count);
            line.append(", RMS=");
            line.append(Format.formatDouble(Math.sqrt(sum / (double)count), 4));
            System.out.println(line.toString());
        }
    }

    public static FalsePositiveReport calculatePositiveNegative(MLRegression method, MatrixMLDataSet data) {
        int truePositive = 0;
        int trueNegative = 0;
        int negativeCount = 0;
        int positiveCount = 0;
        for (MLDataPair pair : data) {
            boolean idealPositive;
            MLData actual = method.compute(pair.getInput());
            boolean actualPositive = actual.getData(0) > actual.getData(1);
            boolean bl = idealPositive = pair.getIdeal().getData(0) > pair.getIdeal().getData(1);
            if (idealPositive) {
                if (actualPositive) {
                    ++truePositive;
                }
                ++positiveCount;
                continue;
            }
            if (!actualPositive) {
                ++trueNegative;
            }
            ++negativeCount;
        }
        return new FalsePositiveReport(truePositive, trueNegative, positiveCount, negativeCount);
    }

    public static MLDataSet[] splitTrainValidate(MLDataSet trainingSet, GenerateRandom rnd, double trainingPercent) {
        if (trainingPercent < 0.0 || trainingPercent > 1.0) {
            throw new EncogError("Training percent must be between 0 and 1.");
        }
        MLDataSet[] result = new MLDataSet[]{new BasicMLDataSet(), new BasicMLDataSet()};
        for (MLDataPair pair : trainingSet) {
            if (rnd.nextDouble() < trainingPercent) {
                result[0].add(pair);
                continue;
            }
            result[1].add(pair);
        }
        return result;
    }

    public static class FalsePositiveReport {
        private final int truePositive;
        private final int trueNegative;
        private final int negativeCount;
        private final int positiveCount;

        public int getCount() {
            return this.negativeCount + this.positiveCount;
        }

        public int getTruePositive() {
            return this.truePositive;
        }

        public int getTrueNegative() {
            return this.trueNegative;
        }

        public int getNegativeCount() {
            return this.negativeCount;
        }

        public int getPositiveCount() {
            return this.positiveCount;
        }

        public FalsePositiveReport(int truePositive, int trueNegative, int positiveCount, int negativeCount) {
            this.truePositive = truePositive;
            this.trueNegative = trueNegative;
            this.positiveCount = positiveCount;
            this.negativeCount = negativeCount;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("(True Positive Correct=");
            result.append(this.truePositive);
            result.append("/");
            result.append(this.positiveCount);
            result.append("(");
            result.append(Format.formatPercent((double)this.truePositive / (double)this.positiveCount));
            result.append(")");
            result.append(",True Negative Correct=");
            result.append(this.trueNegative);
            result.append("/");
            result.append(this.trueNegative);
            result.append("(");
            result.append(Format.formatPercent((double)this.trueNegative / (double)this.negativeCount));
            result.append(")");
            result.append(",Total Correct=");
            result.append(this.truePositive + this.trueNegative);
            result.append("/");
            result.append(this.positiveCount + this.negativeCount);
            result.append("(");
            result.append(Format.formatPercent(((double)this.truePositive + (double)this.trueNegative) / (double)this.getCount()));
            result.append(")");
            result.append(")");
            return result.toString();
        }
    }
}

