/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.downsample;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import org.encog.EncogError;
import org.encog.util.downsample.RGBDownsample;

public class SimpleIntensityDownsample
extends RGBDownsample {
    @Override
    public double[] downSample(Image image, int height, int width) {
        this.processImage(image);
        this.validate(height, width);
        double[] result = new double[height * width * 3];
        PixelGrabber grabber = new PixelGrabber(image, 0, 0, this.getImageWidth(), this.getImageHeight(), true);
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException e) {
            throw new EncogError(e);
        }
        this.setPixelMap((int[])grabber.getPixels());
        int index = 0;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                this.downSampleRegion(x, y);
                result[index++] = (this.getCurrentRed() + this.getCurrentBlue() + this.getCurrentGreen()) / 3;
                ++x;
            }
            ++y;
        }
        return result;
    }
}

