/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.csv;

import java.util.StringTokenizer;
import org.encog.util.csv.CSVFormat;

public final class NumberList {
    public static synchronized double[] fromList(CSVFormat format, String str) {
        if (str.trim().length() == 0) {
            return new double[0];
        }
        int count = 0;
        StringTokenizer tok = new StringTokenizer(str, "" + format.getSeparator());
        while (tok.hasMoreTokens()) {
            tok.nextToken();
            ++count;
        }
        double[] result = new double[count];
        int index = 0;
        StringTokenizer tok2 = new StringTokenizer(str, "" + format.getSeparator());
        while (tok2.hasMoreTokens()) {
            String num = tok2.nextToken();
            double value = format.parse(num);
            result[index++] = value;
        }
        return result;
    }

    public static void toList(CSVFormat format, StringBuilder result, double[] data) {
        NumberList.toList(format, 20, result, data);
    }

    private NumberList() {
    }

    public static int[] fromListInt(CSVFormat format, String str) {
        if (str.trim().length() == 0) {
            return new int[0];
        }
        int count = 0;
        StringTokenizer tok = new StringTokenizer(str, "" + format.getSeparator());
        while (tok.hasMoreTokens()) {
            tok.nextToken();
            ++count;
        }
        int[] result = new int[count];
        int index = 0;
        StringTokenizer tok2 = new StringTokenizer(str, "" + format.getSeparator());
        while (tok2.hasMoreTokens()) {
            String num = tok2.nextToken();
            int value = Integer.parseInt(num);
            result[index++] = value;
        }
        return result;
    }

    public static synchronized void toList(CSVFormat format, int precision, StringBuilder result, double[] data) {
        result.setLength(0);
        int i = 0;
        while (i < data.length) {
            if (i != 0) {
                result.append(format.getSeparator());
            }
            result.append(format.format(data[i], precision));
            ++i;
        }
    }

    public static void toListInt(CSVFormat format, StringBuilder result, int[] data) {
        result.setLength(0);
        int i = 0;
        while (i < data.length) {
            if (i != 0) {
                result.append(format.getSeparator());
            }
            result.append("" + data[i]);
            ++i;
        }
    }
}

