/*
 * Decompiled with CFR 0.152.
 */
package org.encog.parse.expression.common;

import org.encog.ml.prg.EncogProgram;
import org.encog.ml.prg.ProgramNode;
import org.encog.parse.expression.CommonRender;

public class RenderCommonExpression
extends CommonRender {
    private EncogProgram holder;

    public String render(EncogProgram theHolder) {
        this.holder = theHolder;
        ProgramNode node = theHolder.getRootNode();
        return this.renderNode(node);
    }

    private String renderConst(ProgramNode node) {
        if (node.getData().length == 0) {
            return node.getName();
        }
        return node.evaluate().toStringValue();
    }

    private String renderVar(ProgramNode node) {
        int varIndex = (int)node.getData()[0].toIntValue();
        return this.holder.getVariables().getVariableName(varIndex);
    }

    private String renderFunction(ProgramNode node) {
        StringBuilder result = new StringBuilder();
        result.append(node.getName());
        result.append('(');
        int i = 0;
        while (i < node.getChildNodes().size()) {
            if (i > 0) {
                result.append(',');
            }
            ProgramNode childNode = node.getChildNode(i);
            result.append(this.renderNode(childNode));
            ++i;
        }
        result.append(')');
        return result.toString();
    }

    private String renderOperator(ProgramNode node) {
        StringBuilder result = new StringBuilder();
        result.append("(");
        result.append(this.renderNode(node.getChildNode(0)));
        result.append(node.getName());
        result.append(this.renderNode(node.getChildNode(1)));
        result.append(")");
        return result.toString();
    }

    private String renderNode(ProgramNode node) {
        StringBuilder result = new StringBuilder();
        switch (this.determineNodeType(node)) {
            case ConstVal: {
                result.append(this.renderConst(node));
                break;
            }
            case Operator: {
                result.append(this.renderOperator(node));
                break;
            }
            case Variable: {
                result.append(this.renderVar(node));
                break;
            }
            case Function: {
                result.append(this.renderFunction(node));
            }
        }
        return result.toString();
    }
}

