/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.som;

import org.encog.mathutil.matrices.Matrix;
import org.encog.ml.BasicML;
import org.encog.ml.MLClassification;
import org.encog.ml.MLError;
import org.encog.ml.MLResettable;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.som.training.basic.BestMatchingUnit;
import org.encog.util.EngineArray;

public class SOM
extends BasicML
implements MLClassification,
MLResettable,
MLError {
    private static final long serialVersionUID = 1L;
    public static final double VERYSMALL = 1.0E-30;
    private Matrix weights;

    public SOM() {
    }

    public SOM(int inputCount, int outputCount) {
        this.weights = new Matrix(outputCount, inputCount);
    }

    @Override
    public double calculateError(MLDataSet data) {
        BestMatchingUnit bmu = new BestMatchingUnit(this);
        bmu.reset();
        for (MLDataPair pair : data) {
            MLData input = pair.getInput();
            bmu.calculateBMU(input);
        }
        return bmu.getWorstDistance() / 100.0;
    }

    @Override
    public int classify(MLData input) {
        if (input.size() > this.getInputCount()) {
            throw new NeuralNetworkError("Can't classify SOM with input size of " + this.getInputCount() + " with input data of count " + input.size());
        }
        double[][] m = this.weights.getData();
        double[] inputData = input.getData();
        double minDist = Double.POSITIVE_INFINITY;
        int result = -1;
        int i = 0;
        while (i < this.getOutputCount()) {
            double dist = EngineArray.euclideanDistance(inputData, m[i]);
            if (dist < minDist) {
                minDist = dist;
                result = i;
            }
            ++i;
        }
        return result;
    }

    @Override
    public int getInputCount() {
        return this.weights.getCols();
    }

    @Override
    public int getOutputCount() {
        return this.weights.getRows();
    }

    public Matrix getWeights() {
        return this.weights;
    }

    @Override
    public void reset() {
        this.weights.randomize(-1.0, 1.0);
    }

    @Override
    public void reset(int seed) {
        this.reset();
    }

    public void setWeights(Matrix weights) {
        this.weights = weights;
    }

    @Override
    public void updateProperties() {
    }

    public int winner(MLData input) {
        return this.classify(input);
    }
}

