/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.model.config;

import org.encog.ml.data.versatile.VersatileMLDataSet;
import org.encog.ml.data.versatile.columns.ColumnType;
import org.encog.ml.data.versatile.normalizers.OneOfNNormalizer;
import org.encog.ml.data.versatile.normalizers.RangeNormalizer;
import org.encog.ml.data.versatile.normalizers.strategies.BasicNormalizationStrategy;
import org.encog.ml.data.versatile.normalizers.strategies.NormalizationStrategy;
import org.encog.ml.model.config.MethodConfig;

public class NEATConfig
implements MethodConfig {
    @Override
    public String getMethodName() {
        return "neat";
    }

    @Override
    public String suggestModelArchitecture(VersatileMLDataSet dataset) {
        return "cycles=4";
    }

    @Override
    public NormalizationStrategy suggestNormalizationStrategy(VersatileMLDataSet dataset, String architecture) {
        BasicNormalizationStrategy result = new BasicNormalizationStrategy();
        result.assignInputNormalizer(ColumnType.continuous, new RangeNormalizer(0.0, 1.0));
        result.assignInputNormalizer(ColumnType.nominal, new OneOfNNormalizer(0.0, 1.0));
        result.assignInputNormalizer(ColumnType.ordinal, new OneOfNNormalizer(0.0, 1.0));
        result.assignOutputNormalizer(ColumnType.continuous, new RangeNormalizer(0.0, 1.0));
        result.assignOutputNormalizer(ColumnType.nominal, new OneOfNNormalizer(0.0, 1.0));
        result.assignOutputNormalizer(ColumnType.ordinal, new OneOfNNormalizer(0.0, 1.0));
        return result;
    }

    @Override
    public String suggestTrainingType() {
        return "neat-ga";
    }

    @Override
    public String suggestTrainingArgs(String trainingType) {
        return "";
    }

    @Override
    public int determineOutputCount(VersatileMLDataSet dataset) {
        return dataset.getNormHelper().calculateNormalizedOutputCount();
    }
}

