/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.importance;

import org.encog.EncogError;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.importance.AbstractFeatureImportance;
import org.encog.ml.importance.FeatureRank;

public class CorrelationFeatureImportanceCalc
extends AbstractFeatureImportance {
    @Override
    public void performRanking() {
        throw new EncogError("This algorithm requires a dataset to measure performance against, please call performRanking with a dataset.");
    }

    @Override
    public void performRanking(MLDataSet theDataset) {
        if (this.getModel() != null) {
            throw new EncogError("This algorithm does not use a model, please pass null to init for the model.");
        }
        if (theDataset.getIdealSize() != 1) {
            throw new EncogError("This algorithm can only be used with a single-output dataset.");
        }
        double[] mean = new double[1 + theDataset.getInputSize()];
        for (MLDataPair pair : theDataset) {
            mean[0] = mean[0] + pair.getIdeal().getData(0);
            int i = 0;
            while (i < pair.getInput().size()) {
                int n = 1 + i;
                mean[n] = mean[n] + pair.getInput().getData(i);
                ++i;
            }
        }
        int i = 0;
        while (i < mean.length) {
            int n = i++;
            mean[n] = mean[n] / (double)theDataset.size();
        }
        double[] sd = new double[1 + theDataset.getInputSize()];
        for (MLDataPair pair : theDataset) {
            double d = pair.getIdeal().getData(0) - mean[0];
            sd[0] = sd[0] + d * d;
            int i2 = 0;
            while (i2 < pair.getInput().size()) {
                d = pair.getInput().getData(i2) - mean[1 + i2];
                int n = 1 + i2;
                sd[n] = sd[n] + d * d;
                ++i2;
            }
        }
        int i3 = 0;
        while (i3 < mean.length) {
            sd[i3] = Math.sqrt(sd[i3] / (double)theDataset.size());
            ++i3;
        }
        i3 = 0;
        while (i3 < theDataset.getInputSize()) {
            FeatureRank rank = this.getFeatures().get(i3);
            double acc = 0.0;
            for (MLDataPair pair : theDataset) {
                double a = pair.getIdeal().getData(0) - mean[0];
                double b = pair.getInput().getData(i3) - mean[i3 + 1];
                acc += a * b;
            }
            double cov = 1.0 / (1.0 - (double)theDataset.size()) * acc;
            double cor = cov / (sd[0] * sd[i3 + 1]);
            rank.setImportancePercent(Math.abs(cor));
            rank.setTotalWeight(cor);
            ++i3;
        }
    }
}

