/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.hmm.distributions;

import java.util.Arrays;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.ml.hmm.distributions.StateDistribution;

public class DiscreteDistribution
implements StateDistribution {
    private static final long serialVersionUID = 1L;
    private final double[][] probabilities;

    public DiscreteDistribution(double[][] theProbabilities) {
        if (theProbabilities.length == 0) {
            throw new IllegalArgumentException("Invalid empty array");
        }
        this.probabilities = new double[theProbabilities.length][];
        int i = 0;
        while (i < theProbabilities.length) {
            if (theProbabilities[i].length == 0) {
                throw new IllegalArgumentException("Invalid empty array");
            }
            this.probabilities[i] = new double[theProbabilities[i].length];
            int j = 0;
            while (j < this.probabilities[i].length) {
                double d = this.probabilities[i][j] = theProbabilities[i][j];
                if (d < 0.0) {
                    throw new IllegalArgumentException();
                }
                ++j;
            }
            ++i;
        }
    }

    public DiscreteDistribution(int[] cx) {
        this.probabilities = new double[cx.length][];
        int i = 0;
        while (i < cx.length) {
            int c = cx[i];
            this.probabilities[i] = new double[c];
            int j = 0;
            while (j < c) {
                this.probabilities[i][j] = 1.0 / (double)c;
                ++j;
            }
            ++i;
        }
    }

    @Override
    public DiscreteDistribution clone() {
        try {
            return (DiscreteDistribution)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void fit(MLDataSet co) {
        if (co.size() < 1) {
            throw new IllegalArgumentException("Empty observation set");
        }
        int i = 0;
        while (i < this.probabilities.length) {
            int j = 0;
            while (j < this.probabilities[i].length) {
                this.probabilities[i][j] = 0.0;
                ++j;
            }
            for (MLDataPair o : co) {
                double[] dArray = this.probabilities[i];
                int n = (int)o.getInput().getData(i);
                dArray[n] = dArray[n] + 1.0;
            }
            j = 0;
            while (j < this.probabilities[i].length) {
                double[] dArray = this.probabilities[i];
                int n = j++;
                dArray[n] = dArray[n] / (double)co.size();
            }
            ++i;
        }
    }

    @Override
    public void fit(MLDataSet co, double[] weights) {
        if (co.size() < 1 || co.size() != weights.length) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < this.probabilities.length) {
            Arrays.fill(this.probabilities[i], 0.0);
            int j = 0;
            for (MLDataPair o : co) {
                double[] dArray = this.probabilities[i];
                int n = (int)o.getInput().getData(i);
                dArray[n] = dArray[n] + weights[j++];
            }
            ++i;
        }
    }

    @Override
    public MLDataPair generate() {
        BasicMLData result = new BasicMLData(this.probabilities.length);
        int i = 0;
        while (i < this.probabilities.length) {
            double rand = Math.random();
            result.setData(i, this.probabilities[i].length - 1);
            int j = 0;
            while (j < this.probabilities[i].length - 1) {
                double d;
                rand -= this.probabilities[i][j];
                if (d < 0.0) {
                    result.setData(i, j);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return new BasicMLDataPair(result);
    }

    @Override
    public double probability(MLDataPair o) {
        double result = 1.0;
        int i = 0;
        while (i < this.probabilities.length) {
            if (o.getInput().getData(i) > (double)(this.probabilities[i].length - 1)) {
                throw new IllegalArgumentException("Wrong observation value");
            }
            result *= this.probabilities[i][(int)o.getInput().getData(i)];
            ++i;
        }
        return result;
    }

    public double[][] getProbabilities() {
        return this.probabilities;
    }
}

