/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.ea.train.basic;

import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.Callable;
import org.encog.EncogError;
import org.encog.ml.ea.exception.EARuntimeError;
import org.encog.ml.ea.genome.Genome;
import org.encog.ml.ea.opp.EvolutionaryOperator;
import org.encog.ml.ea.species.Species;
import org.encog.ml.ea.train.basic.BasicEA;

public class EAWorker
implements Callable<Object>,
Serializable {
    private final Species species;
    private final Genome[] parents;
    private final Genome[] children;
    private final Random rnd;
    private final BasicEA train;

    public EAWorker(BasicEA theTrain, Species theSpecies) {
        this.train = theTrain;
        this.species = theSpecies;
        this.rnd = this.train.getRandomNumberFactory().factor();
        this.parents = new Genome[this.train.getOperators().maxParents()];
        this.children = new Genome[this.train.getOperators().maxOffspring()];
    }

    private Genome chooseParent() {
        int idx = this.train.getSelection().performSelection(this.rnd, this.species);
        return this.species.getMembers().get(idx);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object call() {
        boolean success = false;
        int tries = this.train.getMaxOperationErrors();
        do {
            try {
                EvolutionaryOperator opp = this.train.getOperators().pickMaxParents(this.rnd, this.species.getMembers().size());
                this.children[0] = null;
                this.parents[0] = this.chooseParent();
                if (opp.parentsNeeded() > 1) {
                    int numAttempts = 5;
                    this.parents[1] = this.chooseParent();
                    while (this.parents[0] == this.parents[1] && numAttempts-- > 0) {
                        this.parents[1] = this.chooseParent();
                    }
                    if (this.parents[0] != this.parents[1]) {
                        opp.performOperation(this.rnd, this.parents, 0, this.children, 0);
                    }
                } else {
                    opp.performOperation(this.rnd, this.parents, 0, this.children, 0);
                    this.children[0].setPopulation(this.parents[0].getPopulation());
                }
                Genome[] genomeArray = this.children;
                int n = this.children.length;
                int n2 = 0;
                while (n2 < n) {
                    Genome child = genomeArray[n2];
                    if (child != null) {
                        child.setPopulation(this.parents[0].getPopulation());
                        if (this.train.getPopulation().getRules().isValid(child)) {
                            child.setBirthGeneration(this.train.getIteration());
                            this.train.calculateScore(child);
                            if (!this.train.addChild(child)) {
                                return null;
                            }
                            success = true;
                        }
                    }
                    ++n2;
                }
            }
            catch (EARuntimeError e) {
                if (--tries >= 0) continue;
                throw new EncogError("Could not perform a successful genetic operaton after " + this.train.getMaxOperationErrors() + " tries.");
            }
            catch (Throwable t) {
                if (this.train.getShouldIgnoreExceptions()) continue;
                this.train.reportError(t);
            }
        } while (!success);
        return null;
    }
}

