/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.ea.population;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.encog.ml.BasicML;
import org.encog.ml.ea.genome.Genome;
import org.encog.ml.ea.genome.GenomeFactory;
import org.encog.ml.ea.population.Population;
import org.encog.ml.ea.rules.BasicRuleHolder;
import org.encog.ml.ea.rules.RuleHolder;
import org.encog.ml.ea.species.BasicSpecies;
import org.encog.ml.ea.species.Species;

public class BasicPopulation
extends BasicML
implements Population,
Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private final List<Species> species = new ArrayList<Species>();
    private Genome bestGenome;
    private GenomeFactory genomeFactory;
    private int populationSize;
    private RuleHolder rules = new BasicRuleHolder();

    public BasicPopulation() {
        this.populationSize = 0;
    }

    public BasicPopulation(int thePopulationSize, GenomeFactory theGenomeFactory) {
        this.populationSize = thePopulationSize;
        this.genomeFactory = theGenomeFactory;
    }

    @Override
    public void clear() {
        this.species.clear();
    }

    @Override
    public Species createSpecies() {
        BasicSpecies species = new BasicSpecies();
        species.setPopulation(this);
        this.getSpecies().add(species);
        return species;
    }

    @Override
    public Species determineBestSpecies() {
        for (Species species : this.species) {
            if (!species.getMembers().contains(this.bestGenome)) continue;
            return species;
        }
        return null;
    }

    @Override
    public List<Genome> flatten() {
        ArrayList<Genome> result = new ArrayList<Genome>();
        for (Species species : this.species) {
            result.addAll(species.getMembers());
        }
        return result;
    }

    @Override
    public Genome getBestGenome() {
        return this.bestGenome;
    }

    @Override
    public GenomeFactory getGenomeFactory() {
        return this.genomeFactory;
    }

    @Override
    public int getMaxIndividualSize() {
        return Integer.MAX_VALUE;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int getPopulationSize() {
        return this.populationSize;
    }

    @Override
    public List<Species> getSpecies() {
        return this.species;
    }

    @Override
    public void setBestGenome(Genome genome) {
        this.bestGenome = genome;
    }

    @Override
    public void setGenomeFactory(GenomeFactory factory) {
        this.genomeFactory = factory;
    }

    public void setName(String theName) {
        this.name = theName;
    }

    @Override
    public void setPopulationSize(int thePopulationSize) {
        this.populationSize = thePopulationSize;
    }

    @Override
    public int size() {
        return this.flatten().size();
    }

    @Override
    public void updateProperties() {
    }

    @Override
    public RuleHolder getRules() {
        return this.rules;
    }

    @Override
    public void setRules(RuleHolder rules) {
        this.rules = rules;
    }

    @Override
    public void purgeInvalidGenomes() {
        int speciesNum = 0;
        while (speciesNum < this.getSpecies().size()) {
            Species species = this.getSpecies().get(speciesNum);
            int genomeNum = 0;
            while (genomeNum < species.getMembers().size()) {
                Genome genome = species.getMembers().get(genomeNum);
                if (Double.isInfinite(genome.getScore()) || Double.isInfinite(genome.getAdjustedScore()) || Double.isNaN(genome.getScore()) || Double.isNaN(genome.getAdjustedScore())) {
                    species.getMembers().remove(genome);
                    continue;
                }
                ++genomeNum;
            }
            if (species.getMembers().size() == 0) {
                this.getSpecies().remove(species);
                continue;
            }
            if (!species.getMembers().contains(species.getLeader())) {
                species.setLeader(species.getMembers().get(0));
                species.setBestScore(species.getLeader().getScore());
            }
            ++speciesNum;
        }
    }
}

