/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.cross;

import java.util.ArrayList;
import java.util.List;
import org.encog.mathutil.randomize.generate.GenerateRandom;
import org.encog.mathutil.randomize.generate.MersenneTwisterGenerateRandom;
import org.encog.ml.data.cross.DataFold;
import org.encog.ml.data.versatile.MatrixMLDataSet;
import org.encog.util.EngineArray;

public class KFoldCrossvalidation {
    private final MatrixMLDataSet baseDataset;
    private final int k;
    private final List<DataFold> folds = new ArrayList<DataFold>();
    private GenerateRandom rnd = new MersenneTwisterGenerateRandom();

    public KFoldCrossvalidation(MatrixMLDataSet theBaseDataset, int theK) {
        this.baseDataset = theBaseDataset;
        this.k = theK;
    }

    public GenerateRandom getRnd() {
        return this.rnd;
    }

    public void setRnd(GenerateRandom rnd) {
        this.rnd = rnd;
    }

    public MatrixMLDataSet getBaseDataset() {
        return this.baseDataset;
    }

    public int getK() {
        return this.k;
    }

    public List<DataFold> getFolds() {
        return this.folds;
    }

    private int[] buildFirstList(int length) {
        int[] result = new int[length];
        if (this.baseDataset == null) {
            int i = 0;
            while (i < length) {
                result[i] = i;
                ++i;
            }
        } else {
            int i = 0;
            while (i < length) {
                result[i] = this.baseDataset.getMask()[i];
                ++i;
            }
        }
        return result;
    }

    private void shuffleList(int[] list) {
        int i = list.length - 1;
        while (i > 0) {
            int n = this.rnd.nextInt(i + 1);
            int t = list[i];
            list[i] = list[n];
            list[n] = t;
            --i;
        }
    }

    private List<int[]> allocateFolds() {
        ArrayList<int[]> folds = new ArrayList<int[]>();
        int countPer = this.baseDataset.size() / this.k;
        int countFirst = this.baseDataset.size() - countPer * (this.k - 1);
        folds.add(new int[countFirst]);
        int i = 1;
        while (i < this.k) {
            folds.add(new int[countPer]);
            ++i;
        }
        return folds;
    }

    private void populateFolds(List<int[]> folds, int[] firstList) {
        int idx = 0;
        for (int[] fold : folds) {
            int i = 0;
            while (i < fold.length) {
                fold[i] = firstList[idx++];
                ++i;
            }
        }
    }

    private void buildSets(List<int[]> foldContents) {
        this.folds.clear();
        int i = 0;
        while (i < this.k) {
            int trainingSize = 0;
            int validationSize = 0;
            int j = 0;
            while (j < foldContents.size()) {
                int foldSize = foldContents.get(j).length;
                if (j == i) {
                    validationSize += foldSize;
                } else {
                    trainingSize += foldSize;
                }
                ++j;
            }
            int[] trainingMask = new int[trainingSize];
            int[] validationMask = new int[validationSize];
            int trainingIndex = 0;
            int j2 = 0;
            while (j2 < foldContents.size()) {
                int[] source = foldContents.get(j2);
                if (j2 == i) {
                    EngineArray.arrayCopy(source, 0, validationMask, 0, source.length);
                } else {
                    EngineArray.arrayCopy(source, 0, trainingMask, trainingIndex, source.length);
                    trainingIndex += source.length;
                }
                ++j2;
            }
            MatrixMLDataSet training = new MatrixMLDataSet(this.baseDataset, trainingMask);
            MatrixMLDataSet validation = new MatrixMLDataSet(this.baseDataset, validationMask);
            this.folds.add(new DataFold(training, validation));
            ++i;
        }
    }

    public void process(boolean shuffle) {
        int[] firstList = this.buildFirstList(this.baseDataset.size());
        if (shuffle) {
            this.shuffleList(firstList);
        }
        List<int[]> foldContents = this.allocateFolds();
        this.populateFolds(foldContents, firstList);
        this.buildSets(foldContents);
    }
}

