/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.buffer;

import org.encog.NullStatusReportable;
import org.encog.StatusReportable;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.ml.data.basic.BasicMLDataSet;
import org.encog.ml.data.buffer.codec.DataSetCODEC;

public class MemoryDataLoader {
    private final DataSetCODEC codec;
    private StatusReportable status;
    private BasicMLDataSet result;

    public MemoryDataLoader(DataSetCODEC theCodec) {
        this.codec = theCodec;
        this.status = new NullStatusReportable();
    }

    public final MLDataSet external2Memory() {
        this.status.report(0, 0, "Importing to memory");
        if (this.result == null) {
            this.result = new BasicMLDataSet();
        }
        double[] input = new double[this.codec.getInputSize()];
        double[] ideal = new double[this.codec.getIdealSize()];
        double[] significance = new double[1];
        this.codec.prepareRead();
        int currentRecord = 0;
        int lastUpdate = 0;
        while (this.codec.read(input, ideal, significance)) {
            BasicMLData a = null;
            BasicMLData b = null;
            a = new BasicMLData(input);
            if (this.codec.getIdealSize() > 0) {
                b = new BasicMLData(ideal);
            }
            BasicMLDataPair pair = new BasicMLDataPair(a, b);
            pair.setSignificance(significance[0]);
            this.result.add(pair);
            ++currentRecord;
            if (++lastUpdate < 10000) continue;
            lastUpdate = 0;
            this.status.report(0, currentRecord, "Importing...");
        }
        this.codec.close();
        this.status.report(0, 0, "Done importing to memory");
        return this.result;
    }

    public DataSetCODEC getCodec() {
        return this.codec;
    }

    public BasicMLDataSet getResult() {
        return this.result;
    }

    public StatusReportable getStatus() {
        return this.status;
    }

    public void setResult(BasicMLDataSet theResult) {
        this.result = theResult;
    }

    public void setStatus(StatusReportable theStatus) {
        this.status = theStatus;
    }
}

