/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.basic;

import java.io.Serializable;
import org.encog.ml.data.MLData;
import org.encog.ml.data.basic.BasicMLDataCentroid;
import org.encog.util.kmeans.Centroid;

public class BasicMLData
implements MLData,
Serializable,
Cloneable {
    private static final long serialVersionUID = -3644304891793584603L;
    private double[] data;

    public BasicMLData(double[] d) {
        this(d.length);
        System.arraycopy(d, 0, this.data, 0, d.length);
    }

    public BasicMLData(int size) {
        this.data = new double[size];
    }

    public BasicMLData(MLData d) {
        this(d.size());
        System.arraycopy(d.getData(), 0, this.data, 0, d.size());
    }

    @Override
    public void add(int index, double value) {
        int n = index;
        this.data[n] = this.data[n] + value;
    }

    @Override
    public void clear() {
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = 0.0;
            ++i;
        }
    }

    @Override
    public MLData clone() {
        return new BasicMLData(this);
    }

    @Override
    public double[] getData() {
        return this.data;
    }

    @Override
    public double getData(int index) {
        return this.data[index];
    }

    @Override
    public void setData(double[] theData) {
        this.data = theData;
    }

    @Override
    public void setData(int index, double d) {
        this.data[index] = d;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append(this.getClass().getSimpleName());
        builder.append(":");
        int i = 0;
        while (i < this.data.length) {
            if (i != 0) {
                builder.append(',');
            }
            builder.append(this.data[i]);
            ++i;
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public Centroid<MLData> createCentroid() {
        return new BasicMLDataCentroid(this);
    }

    public MLData plus(MLData o) {
        if (this.size() != o.size()) {
            throw new IllegalArgumentException();
        }
        BasicMLData result = new BasicMLData(this.size());
        int i = 0;
        while (i < this.size()) {
            result.setData(i, this.getData(i) + o.getData(i));
            ++i;
        }
        return result;
    }

    public MLData times(double d) {
        BasicMLData result = new BasicMLData(this.size());
        int i = 0;
        while (i < this.size()) {
            result.setData(i, this.getData(i) * d);
            ++i;
        }
        return result;
    }

    public MLData minus(MLData o) {
        if (this.size() != o.size()) {
            throw new IllegalArgumentException();
        }
        BasicMLData result = new BasicMLData(this.size());
        int i = 0;
        while (i < this.size()) {
            result.setData(i, this.getData(i) - o.getData(i));
            ++i;
        }
        return result;
    }

    public MLData threshold(double thresholdValue, double lowValue, double highValue) {
        BasicMLData result = new BasicMLData(this.size());
        int i = 0;
        while (i < this.size()) {
            if (this.getData(i) > thresholdValue) {
                result.setData(i, highValue);
            } else {
                result.setData(i, lowValue);
            }
            ++i;
        }
        return result;
    }
}

