/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.bayesian.bif;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.encog.ml.bayesian.BayesianChoice;
import org.encog.ml.bayesian.BayesianError;
import org.encog.ml.bayesian.BayesianEvent;
import org.encog.ml.bayesian.BayesianNetwork;
import org.encog.ml.bayesian.bif.BIFHandler;
import org.encog.ml.bayesian.table.TableLine;
import org.encog.parse.tags.write.WriteXML;
import org.encog.util.csv.CSVFormat;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BIFUtil {
    public static BayesianNetwork readBIF(String f) {
        return BIFUtil.readBIF(new File(f));
    }

    public static BayesianNetwork readBIF(File f) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            BayesianNetwork bayesianNetwork = BIFUtil.readBIF(fis);
            return bayesianNetwork;
        }
        catch (IOException ex) {
            throw new BayesianError(ex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static BayesianNetwork readBIF(InputStream is) {
        try {
            BIFHandler h = new BIFHandler();
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            sp.parse(is, (DefaultHandler)h);
            return h.getNetwork();
        }
        catch (IOException ex) {
            throw new BayesianError(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new BayesianError(ex);
        }
        catch (SAXException ex) {
            throw new BayesianError(ex);
        }
    }

    public static void writeBIF(String fn, BayesianNetwork network) {
        BIFUtil.writeBIF(new File(fn), network);
    }

    public static void writeBIF(File file, BayesianNetwork network) {
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(file);
                BIFUtil.writeBIF(fos, network);
            }
            catch (IOException ex) {
                throw new BayesianError(ex);
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void writeBIF(OutputStream os, BayesianNetwork network) {
        WriteXML xml = new WriteXML(os);
        xml.beginDocument();
        xml.addAttribute("VERSION", "0.3");
        xml.beginTag("BIF");
        xml.beginTag("NETWORK");
        xml.addProperty("NAME", "Bayes Network, Generated by Encog");
        for (BayesianEvent event : network.getEvents()) {
            xml.addAttribute("TYPE", "nature");
            xml.beginTag("VARIABLE");
            xml.addProperty("NAME", event.getLabel());
            for (BayesianChoice str : event.getChoices()) {
                xml.addProperty("OUTCOME", str.getLabel());
            }
            xml.endTag();
        }
        for (BayesianEvent event : network.getEvents()) {
            xml.beginTag("DEFINITION");
            xml.addProperty("FOR", event.getLabel());
            for (BayesianEvent parentEvent : event.getParents()) {
                xml.addProperty("GIVEN", parentEvent.getLabel());
            }
            xml.addAttribute("TABLE", BIFUtil.generateTable(event));
            xml.endTag();
        }
        xml.endTag();
        xml.endTag();
        xml.endDocument();
    }

    public static String generateTable(BayesianEvent event) {
        StringBuilder s = new StringBuilder();
        boolean tableIndex = false;
        int[] args = new int[event.getParents().size()];
        do {
            int result = 0;
            while (result < event.getChoices().size()) {
                TableLine line = event.getTable().findLine(result, args);
                if (s.length() > 0) {
                    s.append(" ");
                }
                s.append(CSVFormat.EG_FORMAT.format(line.getProbability(), 10));
                ++result;
            }
        } while (BIFUtil.rollArgs(event, args));
        return s.toString();
    }

    public static boolean rollArgs(BayesianEvent event, int[] args) {
        int currentIndex = event.getParents().size() - 1;
        boolean done = false;
        boolean eof = false;
        if (event.getParents().size() == 0) {
            done = true;
            eof = true;
        }
        while (!done) {
            int v = args[currentIndex];
            if (++v < event.getParents().get(currentIndex).getChoices().size()) {
                args[currentIndex] = v;
                done = true;
                break;
            }
            args[currentIndex] = 0;
            if (--currentIndex >= 0) continue;
            done = true;
            eof = true;
        }
        return !eof;
    }
}

