/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.bayesian;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.encog.ml.BasicML;
import org.encog.ml.MLClassification;
import org.encog.ml.MLError;
import org.encog.ml.MLResettable;
import org.encog.ml.bayesian.BayesianChoice;
import org.encog.ml.bayesian.BayesianError;
import org.encog.ml.bayesian.BayesianEvent;
import org.encog.ml.bayesian.EventType;
import org.encog.ml.bayesian.parse.ParseProbability;
import org.encog.ml.bayesian.parse.ParsedChoice;
import org.encog.ml.bayesian.parse.ParsedEvent;
import org.encog.ml.bayesian.parse.ParsedProbability;
import org.encog.ml.bayesian.query.BayesianQuery;
import org.encog.ml.bayesian.query.enumerate.EnumerationQuery;
import org.encog.ml.bayesian.query.sample.EventState;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.util.EngineArray;
import org.encog.util.csv.CSVFormat;

public class BayesianNetwork
extends BasicML
implements MLClassification,
MLResettable,
Serializable,
MLError {
    public static final String[] CHOICES_TRUE_FALSE = new String[]{"true", "false"};
    private final Map<String, BayesianEvent> eventMap = new HashMap<String, BayesianEvent>();
    private final List<BayesianEvent> events = new ArrayList<BayesianEvent>();
    private BayesianQuery query = new EnumerationQuery(this);
    private boolean[] inputPresent;
    private int classificationTarget;
    private double[] classificationProbabilities;

    public Map<String, BayesianEvent> getEventMap() {
        return this.eventMap;
    }

    public List<BayesianEvent> getEvents() {
        return this.events;
    }

    public BayesianEvent getEvent(String label) {
        return this.eventMap.get(label);
    }

    public BayesianEvent getEventError(String label) {
        if (!this.eventExists(label)) {
            throw new BayesianError("Undefined label: " + label);
        }
        return this.eventMap.get(label);
    }

    public boolean eventExists(String label) {
        return this.eventMap.containsKey(label);
    }

    public void createEvent(BayesianEvent event) {
        if (this.eventExists(event.getLabel())) {
            throw new BayesianError("The label \"" + event.getLabel() + "\" has already been defined.");
        }
        this.eventMap.put(event.getLabel(), event);
        this.events.add(event);
    }

    public BayesianEvent createEvent(String label, List<BayesianChoice> options) {
        if (label == null) {
            throw new BayesianError("Can't create event with null label name");
        }
        if (this.eventExists(label)) {
            throw new BayesianError("The label \"" + label + "\" has already been defined.");
        }
        BayesianEvent event = options.size() == 0 ? new BayesianEvent(label) : new BayesianEvent(label, options);
        this.createEvent(event);
        return event;
    }

    public BayesianEvent createEvent(String label, String ... options) {
        if (label == null) {
            throw new BayesianError("Can't create event with null label name");
        }
        if (this.eventExists(label)) {
            throw new BayesianError("The label \"" + label + "\" has already been defined.");
        }
        BayesianEvent event = options.length == 0 ? new BayesianEvent(label) : new BayesianEvent(label, options);
        this.createEvent(event);
        return event;
    }

    public void createDependency(BayesianEvent parentEvent, BayesianEvent childEvent) {
        if (!this.hasDependency(parentEvent, childEvent)) {
            parentEvent.addChild(childEvent);
            childEvent.addParent(parentEvent);
        }
    }

    private boolean hasDependency(BayesianEvent parentEvent, BayesianEvent childEvent) {
        return parentEvent.getChildren().contains(childEvent);
    }

    public void createDependency(BayesianEvent parentEvent, BayesianEvent ... children) {
        BayesianEvent[] bayesianEventArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            BayesianEvent childEvent = bayesianEventArray[n2];
            parentEvent.addChild(childEvent);
            childEvent.addParent(parentEvent);
            ++n2;
        }
    }

    public void createDependency(String parentEventLabel, String childEventLabel) {
        BayesianEvent parentEvent = this.getEventError(parentEventLabel);
        BayesianEvent childEvent = this.getEventError(childEventLabel);
        this.createDependency(parentEvent, childEvent);
    }

    public String getContents() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (BayesianEvent e : this.events) {
            if (!first) {
                result.append(" ");
            }
            first = false;
            result.append(e.toFullString());
        }
        return result.toString();
    }

    public void setContents(String line) {
        String eventLabel;
        ParsedEvent parsedEvent;
        List<ParsedProbability> list = ParseProbability.parseProbabilityList(this, line);
        ArrayList<String> labelList = new ArrayList<String>();
        for (ParsedProbability prob : list) {
            parsedEvent = prob.getChildEvent();
            eventLabel = parsedEvent.getLabel();
            labelList.add(eventLabel);
            BayesianEvent e = this.getEvent(eventLabel);
            if (e != null) continue;
            ArrayList<BayesianChoice> cl = new ArrayList<BayesianChoice>();
            for (ParsedChoice c : parsedEvent.getList()) {
                cl.add(new BayesianChoice(c.getLabel(), c.getMin(), c.getMax()));
            }
            this.createEvent(eventLabel, cl);
        }
        int i = 0;
        while (i < this.events.size()) {
            BayesianEvent event = this.events.get(i);
            if (!labelList.contains(event.getLabel())) {
                this.removeEvent(event);
            }
            ++i;
        }
        for (ParsedProbability prob : list) {
            parsedEvent = prob.getChildEvent();
            eventLabel = parsedEvent.getLabel();
            BayesianEvent event = this.requireEvent(eventLabel);
            ArrayList<String> givenList = new ArrayList<String>();
            for (ParsedEvent given : prob.getGivenEvents()) {
                if (!event.hasGiven(given.getLabel())) {
                    BayesianEvent givenEvent = this.requireEvent(given.getLabel());
                    this.createDependency(givenEvent, event);
                }
                givenList.add(given.getLabel());
            }
            int i2 = 0;
            while (i2 < event.getParents().size()) {
                BayesianEvent event2 = event.getParents().get(i2);
                if (!givenList.contains(event2.getLabel())) {
                    this.removeDependency(event2, event);
                }
                ++i2;
            }
        }
        this.finalizeStructure();
        if (this.query != null) {
            this.query.finalizeStructure();
        }
    }

    private void removeDependency(BayesianEvent parent, BayesianEvent child) {
        parent.getChildren().remove(child);
        child.getParents().remove(parent);
    }

    private void removeEvent(BayesianEvent event) {
        for (BayesianEvent e : event.getParents()) {
            e.getChildren().remove(event);
        }
        this.eventMap.remove(event.getLabel());
        this.events.remove(event);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (BayesianEvent e : this.events) {
            if (!first) {
                result.append(" ");
            }
            first = false;
            result.append(e.toString());
        }
        return result.toString();
    }

    public int calculateParameterCount() {
        int result = 0;
        for (BayesianEvent e : this.eventMap.values()) {
            result += e.calculateParameterCount();
        }
        return result;
    }

    public void finalizeStructure() {
        for (BayesianEvent e : this.eventMap.values()) {
            e.finalizeStructure();
        }
        if (this.query != null) {
            this.query.finalizeStructure();
        }
        this.inputPresent = new boolean[this.events.size()];
        EngineArray.fill(this.inputPresent, true);
        this.classificationTarget = -1;
    }

    public void validate() {
        for (BayesianEvent e : this.eventMap.values()) {
            e.validate();
        }
    }

    private boolean isGiven(BayesianEvent[] given, BayesianEvent e) {
        BayesianEvent[] bayesianEventArray = given;
        int n = given.length;
        int n2 = 0;
        while (n2 < n) {
            BayesianEvent e2 = bayesianEventArray[n2];
            if (e == e2) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isDescendant(BayesianEvent a, BayesianEvent b) {
        if (a == b) {
            return true;
        }
        for (BayesianEvent e : b.getChildren()) {
            if (!this.isDescendant(a, e)) continue;
            return true;
        }
        return false;
    }

    private boolean isGivenOrDescendant(BayesianEvent[] given, BayesianEvent e) {
        BayesianEvent[] bayesianEventArray = given;
        int n = given.length;
        int n2 = 0;
        while (n2 < n) {
            BayesianEvent e2 = bayesianEventArray[n2];
            if (this.isDescendant(e2, e)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isCondIndependent(boolean previousHead, BayesianEvent a, BayesianEvent goal, Set<BayesianEvent> searched, BayesianEvent ... given) {
        if (a == goal) {
            return false;
        }
        for (BayesianEvent e : a.getChildren()) {
            if (searched.contains(e) && this.isGiven(given, a)) continue;
            searched.add(e);
            if (this.isCondIndependent(true, e, goal, searched, given)) continue;
            return false;
        }
        for (BayesianEvent e : a.getParents()) {
            if (searched.contains(e)) continue;
            searched.add(e);
            if (previousHead && !this.isGivenOrDescendant(given, a) || this.isCondIndependent(false, e, goal, searched, given)) continue;
            return false;
        }
        return true;
    }

    public boolean isCondIndependent(BayesianEvent a, BayesianEvent b, BayesianEvent ... given) {
        HashSet<BayesianEvent> searched = new HashSet<BayesianEvent>();
        return this.isCondIndependent(false, a, b, searched, given);
    }

    public BayesianQuery getQuery() {
        return this.query;
    }

    public void setQuery(BayesianQuery query) {
        this.query = query;
    }

    @Override
    public int getInputCount() {
        return this.events.size();
    }

    @Override
    public int getOutputCount() {
        return 1;
    }

    public double computeProbability(MLData input) {
        int inputIndex = 0;
        int i = 0;
        while (i < this.events.size()) {
            BayesianEvent event = this.events.get(i);
            EventState state = this.query.getEventState(event);
            if (state.getEventType() == EventType.Evidence) {
                state.setValue((int)input.getData(inputIndex++));
            }
            ++i;
        }
        this.query.execute();
        return this.query.getProbability();
    }

    public void defineProbability(String line, double probability) {
        ParseProbability parse = new ParseProbability(this);
        ParsedProbability parsedProbability = parse.parse(line);
        parsedProbability.defineTruthTable(this, probability);
    }

    public void defineProbability(String line) {
        int index = line.lastIndexOf(61);
        boolean error = false;
        double prob = 0.0;
        String left = "";
        String right = "";
        if (index != -1) {
            left = line.substring(0, index);
            right = line.substring(index + 1);
            try {
                prob = CSVFormat.EG_FORMAT.parse(right);
            }
            catch (NumberFormatException ex) {
                error = true;
            }
        }
        if (error || index == -1) {
            throw new BayesianError("Probability must be of the form \"P(event|condition1,condition2,etc.)=0.5\".  Conditions are optional.");
        }
        this.defineProbability(left, prob);
    }

    public BayesianEvent requireEvent(String label) {
        BayesianEvent result = this.getEvent(label);
        if (result == null) {
            throw new BayesianError("The event " + label + " is not defined.");
        }
        return result;
    }

    public void defineRelationship(String line) {
        ParseProbability parse = new ParseProbability(this);
        ParsedProbability parsedProbability = parse.parse(line);
        parsedProbability.defineRelationships(this);
    }

    public double performQuery(String line) {
        BayesianEvent event;
        if (this.query == null) {
            throw new BayesianError("This Bayesian network does not have a query to define.");
        }
        ParseProbability parse = new ParseProbability(this);
        ParsedProbability parsedProbability = parse.parse(line);
        BayesianQuery q = this.query.clone();
        q.reset();
        for (ParsedEvent parsedEvent : parsedProbability.getGivenEvents()) {
            event = this.requireEvent(parsedEvent.getLabel());
            q.defineEventType(event, EventType.Evidence);
            q.setEventValue(event, parsedEvent.resolveValue(event));
        }
        for (ParsedEvent parsedEvent : parsedProbability.getBaseEvents()) {
            event = this.requireEvent(parsedEvent.getLabel());
            q.defineEventType(event, EventType.Outcome);
            q.setEventValue(event, parsedEvent.resolveValue(event));
        }
        q.locateEventTypes();
        q.execute();
        return q.getProbability();
    }

    @Override
    public void updateProperties() {
    }

    public int getEventIndex(BayesianEvent event) {
        int i = 0;
        while (i < this.events.size()) {
            if (event == this.events.get(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void removeAllRelations() {
        for (BayesianEvent event : this.events) {
            event.removeAllRelations();
        }
    }

    @Override
    public void reset() {
        this.reset(0);
    }

    @Override
    public void reset(int seed) {
        for (BayesianEvent event : this.events) {
            event.reset();
        }
    }

    public int[] determineClasses(MLData input) {
        int[] result = new int[input.size()];
        int i = 0;
        while (i < input.size()) {
            int classIndex;
            BayesianEvent event = this.events.get(i);
            result[i] = classIndex = event.matchChoiceToRange(input.getData(i));
            ++i;
        }
        return result;
    }

    @Override
    public int classify(MLData input) {
        if (this.classificationTarget < 0 || this.classificationTarget >= this.events.size()) {
            throw new BayesianError("Must specify classification target by calling setClassificationTarget.");
        }
        int[] d = this.determineClasses(input);
        int i = 0;
        while (i < this.events.size()) {
            BayesianEvent event = this.events.get(i);
            if (i == this.classificationTarget) {
                this.query.defineEventType(event, EventType.Outcome);
            } else if (this.inputPresent[i]) {
                this.query.defineEventType(event, EventType.Evidence);
                this.query.setEventValue(event, d[i]);
            } else {
                this.query.defineEventType(event, EventType.Hidden);
                this.query.setEventValue(event, d[i]);
            }
            ++i;
        }
        BayesianEvent outcomeEvent = this.events.get(this.classificationTarget);
        this.classificationProbabilities = new double[outcomeEvent.getChoices().size()];
        int i2 = 0;
        while (i2 < outcomeEvent.getChoices().size()) {
            this.query.setEventValue(outcomeEvent, i2);
            this.query.execute();
            this.classificationProbabilities[i2] = this.query.getProbability();
            ++i2;
        }
        return EngineArray.maxIndex(this.classificationProbabilities);
    }

    public int getClassificationTarget() {
        return this.classificationTarget;
    }

    public boolean isInputPresent(int idx) {
        return this.inputPresent[idx];
    }

    public void defineClassificationStructure(String line) {
        List<ParsedProbability> list = ParseProbability.parseProbabilityList(this, line);
        if (list.size() > 1) {
            throw new BayesianError("Must only define a single probability, not a chain.");
        }
        if (list.size() == 0) {
            throw new BayesianError("Must define at least one probability.");
        }
        for (BayesianEvent event : this.events) {
            this.query.defineEventType(event, EventType.Hidden);
        }
        ParsedProbability prob = list.get(0);
        if (prob.getBaseEvents().size() == 0) {
            return;
        }
        BayesianEvent be = this.getEvent(prob.getChildEvent().getLabel());
        this.classificationTarget = this.events.indexOf(be);
        this.query.defineEventType(be, EventType.Outcome);
        for (ParsedEvent parsedGiven : prob.getGivenEvents()) {
            BayesianEvent given = this.getEvent(parsedGiven.getLabel());
            this.query.defineEventType(given, EventType.Evidence);
        }
        this.query.locateEventTypes();
        for (ParsedEvent parsedGiven : prob.getGivenEvents()) {
            BayesianEvent event = this.getEvent(parsedGiven.getLabel());
            this.query.setEventValue(event, this.parseInt(parsedGiven.getValue()));
        }
        this.query.setEventValue(be, this.parseInt(prob.getBaseEvents().get(0).getValue()));
    }

    private int parseInt(String str) {
        if (str == null) {
            return 0;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    public BayesianEvent getClassificationTargetEvent() {
        if (this.classificationTarget == -1) {
            throw new BayesianError("No classification target defined.");
        }
        return this.events.get(this.classificationTarget);
    }

    @Override
    public double calculateError(MLDataSet data) {
        if (!this.hasValidClassificationTarget()) {
            return 1.0;
        }
        this.getClassificationTarget();
        int badCount = 0;
        int totalCount = 0;
        for (MLDataPair pair : data) {
            int c = this.classify(pair.getInput());
            ++totalCount;
            if ((double)c == pair.getInput().getData(this.classificationTarget)) continue;
            ++badCount;
        }
        return (double)badCount / (double)totalCount;
    }

    public String getClassificationStructure() {
        BayesianEvent event;
        StringBuilder result = new StringBuilder();
        result.append("P(");
        boolean first = true;
        int i = 0;
        while (i < this.getEvents().size()) {
            event = this.events.get(i);
            EventState state = this.query.getEventState(event);
            if (state.getEventType() == EventType.Outcome) {
                if (!first) {
                    result.append(",");
                }
                result.append(event.getLabel());
                first = false;
            }
            ++i;
        }
        result.append("|");
        first = true;
        i = 0;
        while (i < this.getEvents().size()) {
            event = this.events.get(i);
            if (this.query.getEventState(event).getEventType() == EventType.Evidence) {
                if (!first) {
                    result.append(",");
                }
                result.append(event.getLabel());
                first = false;
            }
            ++i;
        }
        result.append(")");
        return result.toString();
    }

    public boolean hasValidClassificationTarget() {
        return this.classificationTarget >= 0 && this.classificationTarget < this.events.size();
    }
}

