/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.matrices.hessian;

import org.encog.mathutil.matrices.Matrix;
import org.encog.mathutil.matrices.hessian.ComputeHessian;
import org.encog.ml.data.MLDataSet;
import org.encog.neural.flat.FlatNetwork;
import org.encog.neural.networks.BasicNetwork;
import org.encog.util.EngineArray;

public abstract class BasicHessian
implements ComputeHessian {
    protected MLDataSet training;
    protected BasicNetwork network;
    protected double sse;
    protected double[] gradients;
    protected Matrix hessianMatrix;
    protected double[][] hessian;
    protected FlatNetwork flat;

    @Override
    public void init(BasicNetwork theNetwork, MLDataSet theTraining) {
        int weightCount = theNetwork.getStructure().getFlat().getWeights().length;
        this.flat = theNetwork.getFlat();
        this.training = theTraining;
        this.network = theNetwork;
        this.gradients = new double[weightCount];
        this.hessianMatrix = new Matrix(weightCount, weightCount);
        this.hessian = this.hessianMatrix.getData();
    }

    @Override
    public double[] getGradients() {
        return this.gradients;
    }

    @Override
    public Matrix getHessianMatrix() {
        return this.hessianMatrix;
    }

    @Override
    public double[][] getHessian() {
        return this.hessian;
    }

    @Override
    public void clear() {
        EngineArray.fill(this.gradients, 0.0);
        this.hessianMatrix.clear();
    }

    @Override
    public double getSSE() {
        return this.sse;
    }

    public void updateHessian(double[] d) {
        int weightCount = this.network.getFlat().getWeights().length;
        int i = 0;
        while (i < weightCount) {
            int j = 0;
            while (j < weightCount) {
                double[] dArray = this.hessian[i];
                int n = j;
                dArray[n] = dArray[n] + d[i] * d[j];
                ++j;
            }
            ++i;
        }
    }
}

