/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.matrices;

import java.io.Serializable;
import org.encog.mathutil.matrices.MatrixError;
import org.encog.mathutil.matrices.MatrixMath;
import org.encog.mathutil.matrices.decomposition.LUDecomposition;
import org.encog.mathutil.matrices.decomposition.QRDecomposition;
import org.encog.mathutil.randomize.RangeRandomizer;

public class Matrix
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -7977897210426471675L;
    private final double[][] matrix;

    public static Matrix createColumnMatrix(double[] input) {
        double[][] d = new double[input.length][1];
        int row = 0;
        while (row < d.length) {
            d[row][0] = input[row];
            ++row;
        }
        return new Matrix(d);
    }

    public static Matrix createRowMatrix(double[] input) {
        double[][] d = new double[1][input.length];
        System.arraycopy(input, 0, d[0], 0, input.length);
        return new Matrix(d);
    }

    public Matrix(boolean[][] sourceMatrix) {
        this.matrix = new double[sourceMatrix.length][sourceMatrix[0].length];
        int r = 0;
        while (r < this.getRows()) {
            int c = 0;
            while (c < this.getCols()) {
                if (sourceMatrix[r][c]) {
                    this.set(r, c, 1.0);
                } else {
                    this.set(r, c, -1.0);
                }
                ++c;
            }
            ++r;
        }
    }

    public Matrix(double[][] sourceMatrix) {
        this.matrix = new double[sourceMatrix.length][sourceMatrix[0].length];
        int r = 0;
        while (r < this.getRows()) {
            int c = 0;
            while (c < this.getCols()) {
                this.set(r, c, sourceMatrix[r][c]);
                ++c;
            }
            ++r;
        }
    }

    public Matrix(int rows, int cols) {
        this.matrix = new double[rows][cols];
    }

    public void add(int row, int col, double value) {
        this.validate(row, col);
        double newValue = this.matrix[row][col] + value;
        this.set(row, col, newValue);
    }

    public void add(Matrix theMatrix) {
        double[][] source = theMatrix.getData();
        int row = 0;
        while (row < this.getRows()) {
            int col = 0;
            while (col < this.getCols()) {
                double[] dArray = this.matrix[row];
                int n = col;
                dArray[n] = dArray[n] + source[row][col];
                ++col;
            }
            ++row;
        }
    }

    public void clear() {
        int r = 0;
        while (r < this.getRows()) {
            int c = 0;
            while (c < this.getCols()) {
                this.matrix[r][c] = 0.0;
                ++c;
            }
            ++r;
        }
    }

    public Matrix clone() {
        return new Matrix(this.matrix);
    }

    public boolean equals(Matrix theMatrix, int precision) {
        if (precision < 0) {
            throw new MatrixError("Precision can't be a negative number.");
        }
        double test = Math.pow(10.0, precision);
        if (Double.isInfinite(test) || test > 9.223372036854776E18) {
            throw new MatrixError("Precision of " + precision + " decimal places is not supported.");
        }
        int actualPrecision = (int)Math.pow(10.0, precision);
        double[][] data = theMatrix.getData();
        int r = 0;
        while (r < this.getRows()) {
            int c = 0;
            while (c < this.getCols()) {
                if ((long)(this.matrix[r][c] * (double)actualPrecision) != (long)(data[r][c] * (double)actualPrecision)) {
                    return false;
                }
                ++c;
            }
            ++r;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof Matrix)) {
            return false;
        }
        Matrix otherMyClass = (Matrix)other;
        return this.equals(otherMyClass, 10);
    }

    public int fromPackedArray(double[] array, int index) {
        int i = index;
        int r = 0;
        while (r < this.getRows()) {
            int c = 0;
            while (c < this.getCols()) {
                this.matrix[r][c] = array[i++];
                ++c;
            }
            ++r;
        }
        return i;
    }

    public double get(int row, int col) {
        this.validate(row, col);
        return this.matrix[row][col];
    }

    public double[][] getArrayCopy() {
        double[][] result = new double[this.getRows()][this.getCols()];
        int i = 0;
        while (i < this.getRows()) {
            int j = 0;
            while (j < this.getCols()) {
                result[i][j] = this.matrix[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public Matrix getCol(int col) {
        if (col > this.getCols()) {
            throw new MatrixError("Can't get column #" + col + " because it does not exist.");
        }
        double[][] newMatrix = new double[this.getRows()][1];
        int row = 0;
        while (row < this.getRows()) {
            newMatrix[row][0] = this.matrix[row][col];
            ++row;
        }
        return new Matrix(newMatrix);
    }

    public int getCols() {
        return this.matrix[0].length;
    }

    public double[][] getData() {
        return this.matrix;
    }

    public Matrix getMatrix(int i0, int i1, int j0, int j1) {
        Matrix result = new Matrix(i1 - i0 + 1, j1 - j0 + 1);
        double[][] b = result.getData();
        try {
            int i = i0;
            while (i <= i1) {
                int j = j0;
                while (j <= j1) {
                    b[i - i0][j - j0] = this.matrix[i][j];
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixError("Submatrix indices");
        }
        return result;
    }

    public Matrix getMatrix(int i0, int i1, int[] c) {
        Matrix result = new Matrix(i1 - i0 + 1, c.length);
        double[][] b = result.getData();
        try {
            int i = i0;
            while (i <= i1) {
                int j = 0;
                while (j < c.length) {
                    b[i - i0][j] = this.matrix[i][c[j]];
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixError("Submatrix indices");
        }
        return result;
    }

    public Matrix getMatrix(int[] r, int j0, int j1) {
        Matrix result = new Matrix(r.length, j1 - j0 + 1);
        double[][] b = result.getData();
        try {
            int i = 0;
            while (i < r.length) {
                int j = j0;
                while (j <= j1) {
                    b[i][j - j0] = this.matrix[r[i]][j];
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return result;
    }

    public Matrix getMatrix(int[] r, int[] c) {
        Matrix result = new Matrix(r.length, c.length);
        double[][] b = result.getData();
        try {
            int i = 0;
            while (i < r.length) {
                int j = 0;
                while (j < c.length) {
                    b[i][j] = this.matrix[r[i]][c[j]];
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixError("Submatrix indices");
        }
        return result;
    }

    public Matrix getRow(int row) {
        if (row > this.getRows()) {
            throw new MatrixError("Can't get row #" + row + " because it does not exist.");
        }
        double[][] newMatrix = new double[1][this.getCols()];
        int col = 0;
        while (col < this.getCols()) {
            newMatrix[0][col] = this.matrix[row][col];
            ++col;
        }
        return new Matrix(newMatrix);
    }

    public int getRows() {
        return this.matrix.length;
    }

    public int hashCode() {
        long result = 0L;
        int r = 0;
        while (r < this.getRows()) {
            int c = 0;
            while (c < this.getCols()) {
                result = (long)((double)result + this.matrix[r][c]);
                ++c;
            }
            ++r;
        }
        return (int)(result % Integer.MAX_VALUE);
    }

    public Matrix inverse() {
        return this.solve(MatrixMath.identity(this.getRows()));
    }

    public boolean isVector() {
        if (this.getRows() == 1) {
            return true;
        }
        return this.getCols() == 1;
    }

    public boolean isZero() {
        int row = 0;
        while (row < this.getRows()) {
            int col = 0;
            while (col < this.getCols()) {
                if (this.matrix[row][col] != 0.0) {
                    return false;
                }
                ++col;
            }
            ++row;
        }
        return true;
    }

    public void multiply(double value) {
        int row = 0;
        while (row < this.getRows()) {
            int col = 0;
            while (col < this.getCols()) {
                double[] dArray = this.matrix[row];
                int n = col++;
                dArray[n] = dArray[n] * value;
            }
            ++row;
        }
    }

    public void multiply(double[] vector, double[] result) {
        int i = 0;
        while (i < this.getRows()) {
            result[i] = 0.0;
            int j = 0;
            while (j < this.getCols()) {
                int n = i;
                result[n] = result[n] + this.matrix[i][j] * vector[j];
                ++j;
            }
            ++i;
        }
    }

    public void randomize(double min, double max) {
        int row = 0;
        while (row < this.getRows()) {
            int col = 0;
            while (col < this.getCols()) {
                this.matrix[row][col] = RangeRandomizer.randomize(min, max);
                ++col;
            }
            ++row;
        }
    }

    public void set(double value) {
        int row = 0;
        while (row < this.getRows()) {
            int col = 0;
            while (col < this.getCols()) {
                this.matrix[row][col] = value;
                ++col;
            }
            ++row;
        }
    }

    public void set(int row, int col, double value) {
        this.validate(row, col);
        this.matrix[row][col] = value;
    }

    public void set(Matrix theMatrix) {
        double[][] source = theMatrix.getData();
        int row = 0;
        while (row < this.getRows()) {
            int col = 0;
            while (col < this.getCols()) {
                this.matrix[row][col] = source[row][col];
                ++col;
            }
            ++row;
        }
    }

    public void setMatrix(int i0, int i1, int j0, int j1, Matrix x) {
        try {
            int i = i0;
            while (i <= i1) {
                int j = j0;
                while (j <= j1) {
                    this.matrix[i][j] = x.get(i - i0, j - j0);
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixError("Submatrix indices");
        }
    }

    public void setMatrix(int i0, int i1, int[] c, Matrix x) {
        try {
            int i = i0;
            while (i <= i1) {
                int j = 0;
                while (j < c.length) {
                    this.matrix[i][c[j]] = x.get(i - i0, j);
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] r, int j0, int j1, Matrix x) {
        try {
            int i = 0;
            while (i < r.length) {
                int j = j0;
                while (j <= j1) {
                    this.matrix[r[i]][j] = x.get(i, j - j0);
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] r, int[] c, Matrix x) {
        try {
            int i = 0;
            while (i < r.length) {
                int j = 0;
                while (j < c.length) {
                    this.matrix[r[i]][c[j]] = x.get(i, j);
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixError("Submatrix indices");
        }
    }

    public int size() {
        return this.matrix[0].length * this.matrix.length;
    }

    public Matrix solve(Matrix b) {
        if (this.getRows() == this.getCols()) {
            return new LUDecomposition(this).solve(b);
        }
        return new QRDecomposition(this).solve(b);
    }

    public double sum() {
        double result = 0.0;
        int r = 0;
        while (r < this.getRows()) {
            int c = 0;
            while (c < this.getCols()) {
                result += this.matrix[r][c];
                ++c;
            }
            ++r;
        }
        return result;
    }

    public double[] toPackedArray() {
        double[] result = new double[this.getRows() * this.getCols()];
        int index = 0;
        int r = 0;
        while (r < this.getRows()) {
            int c = 0;
            while (c < this.getCols()) {
                result[index++] = this.matrix[r][c];
                ++c;
            }
            ++r;
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[Matrix: rows=");
        result.append(this.getRows());
        result.append(",cols=");
        result.append(this.getCols());
        result.append("]");
        return result.toString();
    }

    private void validate(int row, int col) {
        if (row >= this.getRows() || row < 0) {
            String str = "The row:" + row + " is out of range:" + this.getRows();
            throw new MatrixError(str);
        }
        if (col >= this.getCols() || col < 0) {
            String str = "The col:" + col + " is out of range:" + this.getCols();
            throw new MatrixError(str);
        }
    }

    public boolean isSquare() {
        return this.getRows() == this.getCols();
    }
}

