/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.error;

import org.encog.ml.MLRegression;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.ea.exception.EARuntimeError;

public class NormalizedError {
    private double min = Double.POSITIVE_INFINITY;
    private double max = Double.NEGATIVE_INFINITY;
    private double mean;
    private double sd;
    private int outputCount = 0;

    public NormalizedError(MLDataSet theData) {
        double d;
        int n;
        int n2;
        double[] dArray;
        double sum = 0.0;
        for (MLDataPair pair : theData) {
            dArray = pair.getIdealArray();
            n2 = dArray.length;
            n = 0;
            while (n < n2) {
                d = dArray[n];
                this.min = Math.min(d, this.min);
                this.max = Math.max(d, this.max);
                sum += d;
                ++this.outputCount;
                ++n;
            }
        }
        this.mean = sum / (double)this.outputCount;
        sum = 0.0;
        for (MLDataPair pair : theData) {
            dArray = pair.getIdealArray();
            n2 = dArray.length;
            n = 0;
            while (n < n2) {
                d = dArray[n];
                double z = d - this.mean;
                sum += z * z;
                ++n;
            }
        }
        this.sd = Math.sqrt(sum / (double)this.outputCount);
    }

    private double calculateSum(MLDataSet theData, MLRegression theModel) {
        double sum = 0.0;
        for (MLDataPair pair : theData) {
            MLData actual;
            try {
                actual = theModel.compute(pair.getInput());
            }
            catch (EARuntimeError e) {
                return Double.NaN;
            }
            int i = 0;
            while (i < pair.getIdeal().size()) {
                double d = actual.getData(i) - pair.getIdeal().getData(i);
                d *= d;
                sum += d;
                ++i;
            }
        }
        return sum;
    }

    public double calculateNormalizedMean(MLDataSet theData, MLRegression theModel) {
        double sum = this.calculateSum(theData, theModel);
        if (Double.isNaN(sum) || Double.isInfinite(sum)) {
            return Double.NaN;
        }
        return Math.sqrt(sum / (double)this.outputCount) / Math.abs(this.mean);
    }

    public double calculateNormalizedRange(MLDataSet theData, MLRegression theModel) {
        double sum = this.calculateSum(theData, theModel);
        if (Double.isNaN(sum) || Double.isInfinite(sum)) {
            return Double.NaN;
        }
        return Math.sqrt(sum / (double)this.outputCount) / (this.max - this.min);
    }
}

