/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ensemble.training;

import org.encog.ensemble.EnsembleTrainFactory;
import org.encog.ml.MLMethod;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.train.MLTrain;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.training.propagation.scg.ScaledConjugateGradient;

public class ScaledConjugateGradientFactory
implements EnsembleTrainFactory {
    private double dropoutRate = 0.0;

    @Override
    public MLTrain getTraining(MLMethod mlMethod, MLDataSet trainingData) {
        return this.getTraining(mlMethod, trainingData, this.dropoutRate);
    }

    @Override
    public MLTrain getTraining(MLMethod mlMethod, MLDataSet trainingData, double dropoutRate) {
        ScaledConjugateGradient scg = new ScaledConjugateGradient((BasicNetwork)mlMethod, trainingData);
        scg.setDroupoutRate(dropoutRate);
        return scg;
    }

    @Override
    public String getLabel() {
        String l = "scg";
        if (this.dropoutRate > 0.0) {
            l = String.valueOf(l) + "-" + this.dropoutRate;
        }
        return l;
    }

    @Override
    public void setDropoutRate(double rate) {
        this.dropoutRate = rate;
    }
}

