/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ca.program.generic;

import java.io.Serializable;
import java.util.Set;
import java.util.TreeSet;
import org.encog.ca.program.basic.BasicProgram;
import org.encog.ca.program.basic.Movement;
import org.encog.ca.program.generic.Trans;
import org.encog.ca.universe.ContinuousCell;
import org.encog.ca.universe.Universe;
import org.encog.ca.universe.UniverseCell;
import org.encog.mathutil.randomize.RangeRandomizer;

public class GenericCA
extends BasicProgram
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double[] physics;
    private Set<Trans> stepTrans = new TreeSet<Trans>();
    private Set<Trans> finalTrans = new TreeSet<Trans>();
    private Universe sourceUniverse;
    private Universe targetUniverse;
    private int ruleCount;

    public GenericCA() {
        super(Movement.MOVE_8WAY);
    }

    public GenericCA(Universe theSourceUniverse, int count) {
        super(Movement.MOVE_8WAY);
        this.sourceUniverse = theSourceUniverse;
        int countPer = this.sourceUniverse.getCellFactory().size() * 3 + 1;
        this.physics = new double[countPer * count * 2];
        this.ruleCount = count;
    }

    @Override
    public void iteration() {
        int height = this.sourceUniverse.getRows();
        int width = this.targetUniverse.getColumns();
        int row = 0;
        while (row < height) {
            int col = 0;
            while (col < width) {
                this.processCell(row, col);
                ++col;
            }
            ++row;
        }
    }

    public Trans findTrans(Set<Trans> s, UniverseCell c) {
        double a = c.getAvg();
        Trans last = null;
        for (Trans t : s) {
            if (a < t.getLimit()) {
                return t;
            }
            last = t;
        }
        return last;
    }

    public void processCell(int row, int col) {
        Movement[] movements = this.getMovements();
        UniverseCell acc = this.sourceUniverse.getCellFactory().factor();
        UniverseCell thisCell = this.sourceUniverse.get(row, col);
        UniverseCell targetCell = this.targetUniverse.get(row, col);
        Trans trans = this.findTrans(this.stepTrans, thisCell);
        Movement[] movementArray = movements;
        int n = movements.length;
        int n2 = 0;
        while (n2 < n) {
            int otherCol;
            Movement movement = movementArray[n2];
            int otherRow = row + movement.getRowMovement();
            if (this.sourceUniverse.isValid(otherRow, otherCol = col + movement.getColumnmMovement())) {
                UniverseCell otherCell = this.sourceUniverse.get(otherRow, otherCol);
                UniverseCell tp = trans.calculate(otherCell);
                ((ContinuousCell)acc).add(tp);
            }
            ++n2;
        }
        Trans trans2 = this.findTrans(this.finalTrans, acc);
        acc = trans2.calculate(acc);
        ((ContinuousCell)acc).clamp(-0.1, 1.1);
        targetCell.copy(acc);
    }

    @Override
    public void randomize() {
        int countPer = this.sourceUniverse.getCellFactory().size() * 3 + 1;
        double[] d = new double[countPer * this.ruleCount * 2];
        int i = 0;
        while (i < this.physics.length) {
            d[i] = RangeRandomizer.randomize(-1.0, 1.0);
            ++i;
        }
        this.setPhysics(d);
    }

    public void setPhysics(double[] d) {
        this.finalTrans.clear();
        this.stepTrans.clear();
        this.physics = (double[])d.clone();
        int cellSize = this.sourceUniverse.getCellFactory().size();
        int countPer = cellSize * 3 + 1;
        int c = this.physics.length / countPer / 2;
        int idx1 = 0;
        int idx2 = c * countPer;
        int i = 0;
        while (i < c) {
            this.stepTrans.add(new Trans(this.sourceUniverse.getCellFactory(), idx1, this.physics));
            this.finalTrans.add(new Trans(this.sourceUniverse.getCellFactory(), idx2, this.physics));
            idx1 += countPer;
            idx2 += countPer;
            ++i;
        }
    }

    @Override
    public Universe getSourceUniverse() {
        return this.sourceUniverse;
    }

    @Override
    public void setSourceUniverse(Universe sourceUniverse) {
        this.sourceUniverse = sourceUniverse;
    }

    @Override
    public Universe getTargetUniverse() {
        return this.targetUniverse;
    }

    @Override
    public void setTargetUniverse(Universe targetUniverse) {
        this.targetUniverse = targetUniverse;
    }
}

