/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ca.program.conway;

import org.encog.ca.program.basic.BasicProgram;
import org.encog.ca.program.basic.Movement;
import org.encog.ca.universe.Universe;
import org.encog.ca.universe.UniverseCell;

public class ConwayProgram
extends BasicProgram {
    private Universe sourceUniverse;
    private Universe targetUniverse;

    public ConwayProgram(Universe theSourceUniverse) {
        super(Movement.MOVE_8WAY);
        this.sourceUniverse = theSourceUniverse;
    }

    @Override
    public void iteration() {
        int height = this.sourceUniverse.getRows();
        int width = this.targetUniverse.getColumns();
        int row = 0;
        while (row < height) {
            int col = 0;
            while (col < width) {
                this.processCell(row, col);
                ++col;
            }
            ++row;
        }
    }

    public void processCell(int row, int col) {
        boolean alive;
        Movement[] movements = this.getMovements();
        UniverseCell thisCell = this.sourceUniverse.get(row, col);
        UniverseCell targetCell = this.targetUniverse.get(row, col);
        int total = 0;
        Movement[] movementArray = movements;
        int n = movements.length;
        int n2 = 0;
        while (n2 < n) {
            UniverseCell otherCell;
            int otherCol;
            Movement movement = movementArray[n2];
            int otherRow = row + movement.getRowMovement();
            if (this.sourceUniverse.isValid(otherRow, otherCol = col + movement.getColumnmMovement()) && (int)(otherCell = this.sourceUniverse.get(otherRow, otherCol)).get(0) > 0) {
                ++total;
            }
            ++n2;
        }
        boolean bl = alive = (int)thisCell.get(0) > 0;
        if (alive) {
            if (total < 2) {
                alive = false;
            }
            if (alive && total > 3) {
                alive = false;
            }
        } else if (total == 3) {
            alive = true;
        }
        if (alive) {
            targetCell.set(0, 1.0);
        } else {
            targetCell.set(0, 0.0);
        }
    }

    @Override
    public void randomize() {
    }

    @Override
    public Universe getSourceUniverse() {
        return this.sourceUniverse;
    }

    @Override
    public void setSourceUniverse(Universe sourceUniverse) {
        this.sourceUniverse = sourceUniverse;
    }

    @Override
    public Universe getTargetUniverse() {
        return this.targetUniverse;
    }

    @Override
    public void setTargetUniverse(Universe targetUniverse) {
        this.targetUniverse = targetUniverse;
    }
}

