/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.quant.util;

import java.util.ArrayList;
import java.util.List;
import org.encog.util.EngineArray;

public class BarBuffer {
    private final List<double[]> data = new ArrayList<double[]>();
    private final int periods;

    public BarBuffer(int thePeriods) {
        this.periods = thePeriods;
    }

    public final void add(double d) {
        double[] da = new double[]{d};
        this.add(da);
    }

    public final void add(double[] d) {
        this.data.add(0, EngineArray.arrayCopy(d));
        if (this.data.size() > this.periods) {
            this.data.remove(this.data.size() - 1);
        }
    }

    public final double average(int idx) {
        double total = 0.0;
        int i = 0;
        while (i < this.data.size()) {
            double[] d = this.data.get(i);
            total += d[idx];
            ++i;
        }
        return total / (double)this.data.size();
    }

    public final double averageGain(int idx) {
        double total = 0.0;
        int count = 0;
        int i = 0;
        while (i < this.data.size() - 1) {
            double[] yesterday;
            double[] today = this.data.get(i);
            double diff = today[idx] - (yesterday = this.data.get(i + 1))[idx];
            if (diff > 0.0) {
                total += diff;
            }
            ++count;
            ++i;
        }
        if (count == 0) {
            return 0.0;
        }
        return total / (double)count;
    }

    public final double averageLoss(int idx) {
        double total = 0.0;
        int count = 0;
        int i = 0;
        while (i < this.data.size() - 1) {
            double[] yesterday;
            double[] today = this.data.get(i);
            double diff = today[idx] - (yesterday = this.data.get(i + 1))[idx];
            if (diff < 0.0) {
                total += Math.abs(diff);
            }
            ++count;
            ++i;
        }
        if (count == 0) {
            return 0.0;
        }
        return total / (double)count;
    }

    public final List<double[]> getData() {
        return this.data;
    }

    public final boolean getFull() {
        return this.data.size() >= this.periods;
    }

    public final double max(int idx) {
        double result = Double.MIN_VALUE;
        for (double[] d : this.data) {
            result = Math.max(d[idx], result);
        }
        return result;
    }

    public final double min(int idx) {
        double result = Double.MAX_VALUE;
        for (double[] d : this.data) {
            result = Math.min(d[idx], result);
        }
        return result;
    }

    public final double[] pop() {
        if (this.data.size() == 0) {
            return null;
        }
        int idx = this.data.size() - 1;
        double[] result = this.data.get(idx);
        this.data.remove(idx);
        return result;
    }
}

