/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.quant.indicators.predictive;

import java.util.Map;
import org.encog.app.analyst.csv.basic.BaseCachedColumn;
import org.encog.app.quant.indicators.Indicator;

public class BestReturn
extends Indicator {
    public static final String NAME = "PredictBestReturn";
    private final int periods;

    public BestReturn(int thePeriods, boolean output) {
        super(NAME, false, output);
        this.periods = thePeriods;
        this.setOutput(output);
    }

    @Override
    public final void calculate(Map<String, BaseCachedColumn> data, int length) {
        double[] close = data.get("close").getData();
        double[] output = this.getData();
        int stop = length - this.periods;
        int i = 0;
        while (i < stop) {
            double bestReturn = Double.MIN_VALUE;
            double baseClose = close[i];
            int j = 1;
            while (j <= this.periods) {
                double newClose = close[i + j];
                double rtn = (newClose - baseClose) / baseClose;
                bestReturn = Math.max(rtn, bestReturn);
                ++j;
            }
            output[i] = bestReturn;
            ++i;
        }
        i = length - this.periods;
        while (i < length) {
            output[i] = 0.0;
            ++i;
        }
        this.setBeginningIndex(0);
        this.setEndingIndex(length - this.periods - 1);
    }

    @Override
    public final int getPeriods() {
        return this.periods;
    }
}

