/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.report;

import java.io.File;
import java.io.IOException;
import org.encog.app.analyst.AnalystError;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.script.AnalystClassItem;
import org.encog.app.analyst.script.DataField;
import org.encog.app.analyst.script.normalize.AnalystField;
import org.encog.app.analyst.script.prop.ScriptProperties;
import org.encog.util.Format;
import org.encog.util.HTMLReport;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;
import org.encog.util.file.FileUtil;

public class AnalystReport {
    public static final int FIVE_SPAN = 5;
    public static final int EIGHT_SPAN = 5;
    private final EncogAnalyst analyst;
    private int rowCount;
    private int missingCount;

    public AnalystReport(EncogAnalyst theAnalyst) {
        this.analyst = theAnalyst;
    }

    private void analyzeFile() {
        ScriptProperties prop = this.analyst.getScript().getProperties();
        String sourceID = prop.getPropertyString("HEADER:DATASOURCE_rawFile");
        File sourceFile = this.analyst.getScript().resolveFilename(sourceID);
        CSVFormat inputFormat = this.analyst.getScript().determineFormat();
        boolean headers = this.analyst.getScript().expectInputHeaders(sourceID);
        this.rowCount = 0;
        this.missingCount = 0;
        ReadCSV csv = new ReadCSV(sourceFile.toString(), headers, inputFormat);
        while (csv.next()) {
            ++this.rowCount;
            if (!csv.hasMissing()) continue;
            ++this.missingCount;
        }
        csv.close();
    }

    public String produceReport() {
        HTMLReport report = new HTMLReport();
        this.analyzeFile();
        report.beginHTML();
        report.title("Encog Analyst Report");
        report.beginBody();
        report.h1("General Statistics");
        report.beginTable();
        report.tablePair("Total row count", Format.formatInteger(this.rowCount));
        report.tablePair("Missing row count", Format.formatInteger(this.missingCount));
        report.endTable();
        report.h1("Field Ranges");
        report.beginTable();
        report.beginRow();
        report.header("Name");
        report.header("Class?");
        report.header("Complete?");
        report.header("Int?");
        report.header("Real?");
        report.header("Max");
        report.header("Min");
        report.header("Mean");
        report.header("Standard Deviation");
        report.endRow();
        DataField[] dataFieldArray = this.analyst.getScript().getFields();
        int n = dataFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataField df = dataFieldArray[n2];
            report.beginRow();
            report.cell(df.getName());
            report.cell(Format.formatYesNo(df.isClass()));
            report.cell(Format.formatYesNo(df.isComplete()));
            report.cell(Format.formatYesNo(df.isInteger()));
            report.cell(Format.formatYesNo(df.isReal()));
            report.cell(Format.formatDouble(df.getMax(), 5));
            report.cell(Format.formatDouble(df.getMin(), 5));
            report.cell(Format.formatDouble(df.getMean(), 5));
            report.cell(Format.formatDouble(df.getStandardDeviation(), 5));
            report.endRow();
            if (df.getClassMembers().size() > 0) {
                report.beginRow();
                report.cell(" ");
                report.beginTableInCell(5);
                report.beginRow();
                report.header("Code");
                report.header("Name");
                report.header("Count");
                report.endRow();
                for (AnalystClassItem item : df.getClassMembers()) {
                    report.beginRow();
                    report.cell(item.getCode());
                    report.cell(item.getName());
                    report.cell(Format.formatInteger(item.getCount()));
                    report.endRow();
                }
                report.endTableInCell();
                report.endRow();
            }
            ++n2;
        }
        report.endTable();
        report.h1("Normalization");
        report.beginTable();
        report.beginRow();
        report.header("Name");
        report.header("Action");
        report.header("High");
        report.header("Low");
        report.endRow();
        for (AnalystField item : this.analyst.getScript().getNormalize().getNormalizedFields()) {
            report.beginRow();
            report.cell(item.getName());
            report.cell(item.getAction().toString());
            report.cell(Format.formatDouble(item.getNormalizedHigh(), 5));
            report.cell(Format.formatDouble(item.getNormalizedLow(), 5));
            report.endRow();
        }
        report.endTable();
        report.h1("Machine Learning");
        report.beginTable();
        report.beginRow();
        report.header("Name");
        report.header("Value");
        report.endRow();
        String t = this.analyst.getScript().getProperties().getPropertyString("ML:CONFIG_type");
        String a = this.analyst.getScript().getProperties().getPropertyString("ML:CONFIG_architecture");
        String rf = this.analyst.getScript().getProperties().getPropertyString("ML:CONFIG_machineLearningFile");
        report.tablePair("Type", t);
        report.tablePair("Architecture", a);
        report.tablePair("Machine Learning File", rf);
        report.endTable();
        report.h1("Files");
        report.beginTable();
        report.beginRow();
        report.header("Name");
        report.header("Filename");
        report.endRow();
        for (String key : this.analyst.getScript().getProperties().getFilenames()) {
            String value = this.analyst.getScript().getProperties().getFilename(key);
            report.beginRow();
            report.cell(key);
            report.cell(value);
            report.endRow();
        }
        report.endTable();
        report.endBody();
        report.endHTML();
        return report.toString();
    }

    public void produceReport(File filename) {
        try {
            String str = this.produceReport();
            FileUtil.writeFileAsString(filename, str);
        }
        catch (IOException ex) {
            throw new AnalystError(ex);
        }
    }
}

