/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.analyze;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.encog.app.analyst.script.AnalystClassItem;
import org.encog.app.analyst.script.AnalystScript;
import org.encog.app.analyst.script.DataField;
import org.encog.util.csv.CSVFormat;

public class AnalyzedField
extends DataField {
    private double total;
    private int instances = 0;
    private double devTotal;
    private final Map<String, AnalystClassItem> classMap = new HashMap<String, AnalystClassItem>();
    private final AnalystScript script;
    private CSVFormat fmt;

    public AnalyzedField(AnalystScript theScript, String name) {
        super(name);
        this.script = theScript;
        this.fmt = this.script.determineFormat();
    }

    public void analyze1(String v) {
        String str;
        block13: {
            boolean accountedFor = false;
            str = v.trim();
            if (str.trim().length() == 0 || str.equals("?")) {
                this.setComplete(false);
                return;
            }
            ++this.instances;
            if (this.isReal()) {
                if (this.fmt.isValid(str)) {
                    double d = this.fmt.parse(str);
                    this.setMax(Math.max(d, this.getMax()));
                    this.setMin(Math.min(d, this.getMin()));
                    this.total += d;
                    accountedFor = true;
                } else {
                    this.setReal(false);
                    if (!this.isInteger()) {
                        this.setMax(0.0);
                        this.setMin(0.0);
                        this.setStandardDeviation(0.0);
                    }
                }
            }
            if (this.isInteger()) {
                try {
                    int i = Integer.parseInt(str);
                    this.setMax(Math.max((double)i, this.getMax()));
                    this.setMin(Math.min((double)i, this.getMin()));
                    if (!accountedFor) {
                        this.total += (double)i;
                    }
                }
                catch (NumberFormatException ex) {
                    this.setInteger(false);
                    if (this.isReal()) break block13;
                    this.setMax(0.0);
                    this.setMin(0.0);
                    this.setStandardDeviation(0.0);
                }
            }
        }
        if (this.isClass()) {
            if (!this.classMap.containsKey(str)) {
                AnalystClassItem item = new AnalystClassItem(str, str, 1);
                this.classMap.put(str, item);
                int max = this.script.getProperties().getPropertyInt("SETUP:CONFIG_maxClassCount");
                if (this.classMap.size() > max) {
                    this.setClass(false);
                }
            } else {
                AnalystClassItem item = this.classMap.get(str);
                item.increaseCount();
            }
        }
    }

    public void analyze2(String str) {
        if (str.trim().length() == 0) {
            return;
        }
        if ((this.isReal() || this.isInteger()) && !str.equals("") && !str.equals("?")) {
            double d = this.fmt.parse(str);
            this.devTotal += Math.pow(d - this.getMean(), 2.0);
        }
    }

    public void completePass1() {
        this.devTotal = 0.0;
        if (this.instances == 0) {
            this.setMean(0.0);
        } else {
            this.setMean(this.total / (double)this.instances);
        }
    }

    public void completePass2() {
        this.setStandardDeviation(Math.sqrt(this.devTotal / (double)this.instances));
    }

    public DataField finalizeField() {
        DataField result = new DataField(this.getName());
        if (Math.abs(this.getMax() - this.getMin()) < 1.0E-13) {
            result.setMin(this.getMin() - 1.0E-4);
            result.setMax(this.getMin() + 1.0E-4);
        } else {
            result.setMin(this.getMin());
            result.setMax(this.getMax());
        }
        result.setName(this.getName());
        result.setMean(this.getMean());
        result.setStandardDeviation(this.getStandardDeviation());
        result.setInteger(this.isInteger());
        result.setReal(this.isReal());
        result.setClass(this.isClass());
        result.setComplete(this.isComplete());
        result.setSource(this.getSource());
        result.getClassMembers().clear();
        if (result.isClass()) {
            List<AnalystClassItem> list = this.getAnalyzedClassMembers();
            result.getClassMembers().addAll(list);
        }
        return result;
    }

    public List<AnalystClassItem> getAnalyzedClassMembers() {
        ArrayList<String> sorted = new ArrayList<String>();
        sorted.addAll(this.classMap.keySet());
        Collections.sort(sorted);
        ArrayList<AnalystClassItem> result = new ArrayList<AnalystClassItem>();
        for (String str : sorted) {
            result.add(this.classMap.get(str));
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[");
        result.append(this.getClass().getSimpleName());
        result.append(" total=");
        result.append(this.total);
        result.append(", instances=");
        result.append(this.instances);
        result.append("]");
        return result.toString();
    }
}

