/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst;

import org.encog.app.analyst.AnalystListener;
import org.encog.ml.train.MLTrain;
import org.encog.util.Format;
import org.encog.util.Stopwatch;

public class ConsoleAnalystListener
implements AnalystListener {
    private String currentTask = "";
    private final Stopwatch stopwatch = new Stopwatch();
    private boolean shutdownRequested;
    private boolean cancelCommand;

    @Override
    public void report(int total, int current, String message) {
        if (total == 0) {
            System.out.println(String.valueOf(current) + " : " + message);
        } else {
            System.out.println(String.valueOf(current) + "/" + total + " : " + message);
        }
    }

    @Override
    public void reportCommandBegin(int total, int current, String name) {
        System.out.println();
        if (total == 0) {
            System.out.println("Beginning Task#" + current + " : " + name);
        } else {
            System.out.println("Beginning Task#" + current + "/" + total + " : " + name);
        }
        this.currentTask = name;
        this.stopwatch.start();
    }

    @Override
    public void reportCommandEnd(boolean cancel) {
        String cancelStr = "";
        this.cancelCommand = false;
        this.stopwatch.stop();
        cancelStr = cancel ? "canceled" : "completed";
        System.out.println("Task " + this.currentTask + " " + cancelStr + ", task elapsed time " + Format.formatTimeSpan((int)(this.stopwatch.getElapsedMilliseconds() / 1000L)));
    }

    @Override
    public void reportTraining(MLTrain train) {
        System.out.println("Iteration #" + Format.formatInteger(train.getIteration()) + " Error:" + Format.formatPercent(train.getError()) + " elapsed time = " + Format.formatTimeSpan((int)(this.stopwatch.getElapsedMilliseconds() / 1000L)));
    }

    @Override
    public void reportTrainingBegin() {
    }

    @Override
    public void reportTrainingEnd() {
    }

    @Override
    public synchronized void requestCancelCommand() {
        this.cancelCommand = true;
    }

    @Override
    public synchronized void requestShutdown() {
        this.shutdownRequested = true;
    }

    @Override
    public synchronized boolean shouldShutDown() {
        return this.shutdownRequested;
    }

    @Override
    public synchronized boolean shouldStopCommand() {
        return this.cancelCommand;
    }
}

