/*
 * Decompiled with CFR 0.152.
 */
package units;

import java.util.Vector;

public class CommandArgs {
    private String letters;
    private Vector<String> optArgs = new Vector();
    private Vector<String> args = new Vector();
    private int errors = 0;

    public CommandArgs(String[] argv, String options, String optionsWithArg, int minargs, int maxargs) {
        String elem;
        int i = 0;
        StringBuffer opts = new StringBuffer();
        while (i < argv.length && (elem = argv[i]).length() != 0 && elem.charAt(0) == '-') {
            if (elem.equals("-")) {
                this.args.addElement("-");
                ++i;
                break;
            }
            if (elem.equals("--")) {
                ++i;
                break;
            }
            String c = elem.substring(1, 2);
            if (optionsWithArg.indexOf(c) >= 0) {
                opts.append(c);
                if (elem.length() > 2) {
                    this.optArgs.addElement(elem.substring(2, elem.length()));
                    ++i;
                    continue;
                }
                if (++i < argv.length && (argv[i].length() == 0 || argv[i].charAt(0) != '-')) {
                    this.optArgs.addElement(argv[i]);
                    ++i;
                    continue;
                }
                System.err.println("Missing argument of option -" + c + ".");
                this.optArgs.addElement(null);
                ++this.errors;
                continue;
            }
            for (int n = 1; n < elem.length(); ++n) {
                c = elem.substring(n, n + 1);
                if (options.indexOf(c) < 0) {
                    System.err.println("Unrecognized option -" + c + ".");
                    ++this.errors;
                    break;
                }
                opts.append(c);
                this.optArgs.addElement(null);
            }
            ++i;
        }
        this.letters = opts.toString();
        while (i < argv.length) {
            this.args.addElement(argv[i]);
            ++i;
        }
        if (this.nArgs() < minargs) {
            System.err.println("Missing argument(s).");
            ++this.errors;
        }
        if (this.nArgs() > maxargs) {
            System.err.println("Too many arguments.");
            ++this.errors;
        }
    }

    public boolean opt(char c) {
        return this.letters.indexOf(c) >= 0;
    }

    public String optArg(char c) {
        int i = this.letters.indexOf(c);
        return i < 0 ? null : this.optArgs.elementAt(i);
    }

    public Vector<String> optArgs(char c) {
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < this.letters.length(); ++i) {
            if (this.letters.charAt(i) != c) continue;
            result.add(this.optArgs.elementAt(i));
        }
        return result;
    }

    public int nArgs() {
        return this.args.size();
    }

    public String arg(int i) {
        return this.args.elementAt(i);
    }

    public Vector<String> args() {
        return this.args;
    }

    public int nErrors() {
        return this.errors;
    }
}

