/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.util;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;

public class PointND<T extends Number>
implements Serializable {
    private static final long serialVersionUID = 3552680202450906771L;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    private final T[] coordinates;

    public PointND(T ... coordinates) {
        this.coordinates = (Number[])Arrays.copyOf(coordinates, coordinates.length);
    }

    public int getDimensions() {
        return this.coordinates.length;
    }

    public T get(int dimension) {
        return this.coordinates[dimension];
    }

    public void set(int dimension, T coordinate) {
        this.coordinates[dimension] = coordinate;
    }

    public void setLocation(T ... coordinates) {
        if (this.getDimensions() != coordinates.length) {
            throw new IllegalArgumentException(MessageFormat.format("Wrong number of dimensions: Expected {0,number,integer} values, got {1,number,integer}.", this.getDimensions(), coordinates.length));
        }
        System.arraycopy(coordinates, 0, this.coordinates, 0, this.getDimensions());
    }

    public Point2D getPoint2D(int dimX, int dimY) {
        if (this.getDimensions() < 2) {
            throw new ArrayIndexOutOfBoundsException("Can't create two-dimensional point from " + this.getDimensions() + "D data.");
        }
        return new Point2D.Double(((Number)this.get(dimX)).doubleValue(), ((Number)this.get(dimY)).doubleValue());
    }

    public Point2D getPoint2D() {
        return this.getPoint2D(0, 1);
    }

    public String toString() {
        return this.getClass().getName() + Arrays.deepToString(this.coordinates);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PointND)) {
            return false;
        }
        PointND p = (PointND)obj;
        if (this.getDimensions() != p.getDimensions()) {
            return false;
        }
        for (int dim = 0; dim < this.coordinates.length; ++dim) {
            T dimA = this.get(dim);
            T dimB = p.get(dim);
            if (!(dimA != null && dimB != null ? !dimA.equals(dimB) : dimA != dimB)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        for (T coordinate : this.coordinates) {
            hashCode ^= coordinate.hashCode();
        }
        return hashCode;
    }
}

