/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.util;

import de.erichseifert.gral.util.MathUtils;
import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public abstract class GeometryUtils {
    public static final double EPSILON = 1.0E-5;
    public static final double EPSILON_SQ = 1.0000000000000002E-10;

    private GeometryUtils() {
        throw new UnsupportedOperationException();
    }

    public static Line2D[] shapeToLines(Shape path, boolean swapped) {
        ArrayDeque<Line2D.Double> lines = new ArrayDeque<Line2D.Double>();
        FlatteningPathIterator i = new FlatteningPathIterator(path.getPathIterator(null), 0.5);
        double[] coords = new double[6];
        double[] coordsPrev = new double[6];
        while (!i.isDone()) {
            Point2D lastPoint;
            Point2D firstPoint;
            int segment = i.currentSegment(coords);
            if (segment == 1 || segment == 4) {
                Line2D.Double line;
                if (!swapped) {
                    line = new Line2D.Double(coordsPrev[0], coordsPrev[1], coords[0], coords[1]);
                    lines.addLast(line);
                } else {
                    line = new Line2D.Double(coords[0], coords[1], coordsPrev[0], coordsPrev[1]);
                    lines.addFirst(line);
                }
            }
            if (segment == 4 && !lines.isEmpty() && !(firstPoint = ((Line2D)lines.getFirst()).getP1()).equals(lastPoint = ((Line2D)lines.getLast()).getP2())) {
                Line2D.Double line;
                if (!swapped) {
                    line = new Line2D.Double(coords[0], coords[1], firstPoint.getX(), firstPoint.getY());
                    lines.addLast(line);
                } else {
                    line = new Line2D.Double(firstPoint.getX(), firstPoint.getY(), coords[0], coords[1]);
                    lines.addFirst(line);
                }
            }
            System.arraycopy(coords, 0, coordsPrev, 0, 6);
            i.next();
        }
        Line2D[] linesArray = new Line2D[lines.size()];
        lines.toArray(linesArray);
        return linesArray;
    }

    public static List<Point2D> intersection(Shape s1, Shape s2) {
        ArrayList<Point2D> intersections = new ArrayList<Point2D>(2);
        Line2D[] lines1 = GeometryUtils.shapeToLines(s1, false);
        Line2D[] lines2 = GeometryUtils.shapeToLines(s2, false);
        for (Line2D l1 : lines1) {
            for (Line2D l2 : lines2) {
                Point2D intersection = GeometryUtils.intersection(l1, l2);
                if (intersection == null) continue;
                intersections.add(intersection);
            }
        }
        return intersections;
    }

    public static Point2D intersection(Line2D l1, Line2D l2) {
        double sqrLen1;
        double sqrLen0;
        Point2D p0 = l1.getP1();
        Point2D.Double d0 = new Point2D.Double(l1.getX2() - p0.getX(), l1.getY2() - p0.getY());
        Point2D p1 = l2.getP1();
        Point2D.Double d1 = new Point2D.Double(l2.getX2() - p1.getX(), l2.getY2() - p1.getY());
        Point2D.Double e = new Point2D.Double(p1.getX() - p0.getX(), p1.getY() - p0.getY());
        double kross = ((Point2D)d0).getX() * ((Point2D)d1).getY() - ((Point2D)d0).getY() * ((Point2D)d1).getX();
        double sqrKross = kross * kross;
        if (sqrKross > 1.0000000000000002E-10 * (sqrLen0 = d0.distanceSq(0.0, 0.0)) * (sqrLen1 = d1.distanceSq(0.0, 0.0))) {
            double s = (((Point2D)e).getX() * ((Point2D)d1).getY() - ((Point2D)e).getY() * ((Point2D)d1).getX()) / kross;
            if (s < 0.0 || s > 1.0) {
                return null;
            }
            double t = (((Point2D)e).getX() * ((Point2D)d0).getY() - ((Point2D)e).getY() * ((Point2D)d0).getX()) / kross;
            if (t < 0.0 || t > 1.0) {
                return null;
            }
            return new Point2D.Double(p0.getX() + s * ((Point2D)d0).getX(), p0.getY() + s * ((Point2D)d0).getY());
        }
        return null;
    }

    public static Area grow(Shape s, double offset) {
        return GeometryUtils.grow(s, offset, 0, 10.0f);
    }

    public static Area grow(Shape s, double offset, int join, float miterlimit) {
        Area shape = new Area(s);
        if (MathUtils.almostEqual(offset, 0.0, 1.0E-5)) {
            return shape;
        }
        BasicStroke stroke = new BasicStroke((float)Math.abs(2.0 * offset), 2, join, miterlimit);
        Area strokeShape = new Area(stroke.createStrokedShape(s));
        if (offset > 0.0) {
            shape.add(strokeShape);
        } else {
            shape.subtract(strokeShape);
        }
        return shape;
    }

    public static Area punch(Area shapeArea, double gap, boolean rounded, Point2D pointPos, Shape pointShape) {
        if (gap <= 1.0E-10 || pointPos == null || pointShape == null) {
            return shapeArea;
        }
        AffineTransform tx = AffineTransform.getTranslateInstance(pointPos.getX(), pointPos.getY());
        int gapJoin = rounded ? 1 : 0;
        Area gapArea = GeometryUtils.grow(tx.createTransformedShape(pointShape), gap, gapJoin, 10.0f);
        shapeArea.subtract(gapArea);
        return shapeArea;
    }

    public static List<PathSegment> getSegments(Shape shape) {
        PathIterator path = shape.getPathIterator(null);
        Point2D.Double pointStart = null;
        Point2D.Double pointEnd = null;
        double[] coords = new double[6];
        LinkedList<PathSegment> segments = new LinkedList<PathSegment>();
        while (!path.isDone()) {
            int type = path.currentSegment(coords);
            if (type == 0 || type == 1) {
                pointEnd = new Point2D.Double(coords[0], coords[1]);
            } else if (type == 2) {
                pointEnd = new Point2D.Double(coords[2], coords[3]);
            } else if (type == 3) {
                pointEnd = new Point2D.Double(coords[4], coords[5]);
            }
            PathSegment segment = new PathSegment(type, pointStart, pointEnd, coords);
            segments.add(segment);
            pointStart = pointEnd;
            path.next();
        }
        return segments;
    }

    public static Shape getShape(List<PathSegment> segments, boolean isDouble) {
        if (isDouble) {
            return GeometryUtils.getShapeDouble(segments);
        }
        return GeometryUtils.getShapeFloat(segments);
    }

    private static Shape getShapeDouble(List<PathSegment> segments) {
        Path2D.Double path = new Path2D.Double(1, segments.size());
        for (PathSegment segment : segments) {
            double[] coords = segment.coords;
            if (segment.type == 0) {
                path.moveTo(coords[0], coords[1]);
                continue;
            }
            if (segment.type == 1) {
                path.lineTo(coords[0], coords[1]);
                continue;
            }
            if (segment.type == 2) {
                path.quadTo(coords[0], coords[1], coords[2], coords[3]);
                continue;
            }
            if (segment.type == 3) {
                path.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                continue;
            }
            if (segment.type != 4) continue;
            path.closePath();
        }
        return path;
    }

    private static Shape getShapeFloat(List<PathSegment> segments) {
        Path2D.Float path = new Path2D.Float(1, segments.size());
        for (PathSegment segment : segments) {
            float[] coords = new float[segment.coords.length];
            for (int i = 0; i < coords.length; ++i) {
                coords[i] = (float)segment.coords[i];
            }
            if (segment.type == 0) {
                path.moveTo(coords[0], coords[1]);
                continue;
            }
            if (segment.type == 1) {
                path.lineTo(coords[0], coords[1]);
                continue;
            }
            if (segment.type == 2) {
                path.quadTo(coords[0], coords[1], coords[2], coords[3]);
                continue;
            }
            if (segment.type == 3) {
                path.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                continue;
            }
            if (segment.type != 4) continue;
            path.closePath();
        }
        return path;
    }

    public static Shape reverse(Shape shape) {
        List<PathSegment> segments = GeometryUtils.getSegments(shape);
        boolean closed = false;
        Path2D.Double reversed = new Path2D.Double(1, segments.size());
        ListIterator<PathSegment> i = segments.listIterator(segments.size());
        while (i.hasPrevious()) {
            PathSegment segment = i.previous();
            if (segment.type == 4) {
                closed = true;
                continue;
            }
            if (reversed.getCurrentPoint() == null) {
                ((Path2D)reversed).moveTo(segment.end.getX(), segment.end.getY());
            }
            if (segment.type == 1) {
                ((Path2D)reversed).lineTo(segment.start.getX(), segment.start.getY());
                continue;
            }
            if (segment.type == 2) {
                ((Path2D)reversed).quadTo(segment.coords[0], segment.coords[1], segment.start.getX(), segment.start.getY());
                continue;
            }
            if (segment.type == 3) {
                ((Path2D)reversed).curveTo(segment.coords[2], segment.coords[3], segment.coords[0], segment.coords[1], segment.start.getX(), segment.start.getY());
                continue;
            }
            if (segment.type != 0 || !closed) continue;
            reversed.closePath();
            closed = false;
        }
        return reversed;
    }

    public static final class PathSegment
    implements Serializable {
        private static final long serialVersionUID = 526444553637955799L;
        public final int type;
        public final Point2D start;
        public final Point2D end;
        public final double[] coords;

        public PathSegment(int type, Point2D start, Point2D end, double[] coords) {
            this.type = type;
            this.start = start;
            this.end = end;
            this.coords = new double[6];
            System.arraycopy(coords, 0, this.coords, 0, 6);
        }
    }
}

