/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.points;

import de.erichseifert.gral.data.Row;
import de.erichseifert.gral.graphics.AbstractDrawable;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawableContainer;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.graphics.Label;
import de.erichseifert.gral.graphics.Location;
import de.erichseifert.gral.graphics.layout.OuterEdgeLayout;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.plots.colors.ColorMapper;
import de.erichseifert.gral.plots.points.AbstractPointRenderer;
import de.erichseifert.gral.plots.points.PointData;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.MathUtils;
import de.erichseifert.gral.util.PointND;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.Format;
import java.text.NumberFormat;

public class DefaultPointRenderer2D
extends AbstractPointRenderer {
    private static final long serialVersionUID = -895832597380598383L;

    @Override
    public Drawable getPoint(final PointData data, final Shape shape) {
        AbstractDrawable drawable = new AbstractDrawable(){
            private static final long serialVersionUID = 1915778739867091906L;

            @Override
            public void draw(DrawingContext context) {
                DefaultPointRenderer2D renderer = DefaultPointRenderer2D.this;
                Axis axisY = data.axes.get(1);
                AxisRenderer axisRendererY = data.axisRenderers.get(1);
                Row row = data.row;
                int col = data.col;
                ColorMapper colors = DefaultPointRenderer2D.this.getColor();
                Paint paint = colors.get(data.index);
                GraphicsUtils.fillPaintedShape(context.getGraphics(), shape, paint, null);
                if (renderer.isErrorVisible()) {
                    int colErrorTop = renderer.getErrorColumnTop();
                    int colErrorBottom = renderer.getErrorColumnBottom();
                    DefaultPointRenderer2D.this.drawErrorBars(context, shape, row, data.index, col, colErrorTop, colErrorBottom, axisY, axisRendererY);
                }
            }
        };
        return drawable;
    }

    protected void drawValueLabel(DrawingContext context, Shape point, Row row, int pointIndex, int col) {
        Comparable<?> value = row.get(col);
        Format format = this.getValueFormat();
        if (format == null && row.isColumnNumeric(col)) {
            format = NumberFormat.getInstance();
        }
        String text = format != null ? format.format(value) : value.toString();
        ColorMapper colors = this.getValueColor();
        Paint paint = colors.get(pointIndex);
        Font font = this.getValueFont();
        double fontSize = font.getSize2D();
        Location location = this.getValueLocation();
        double alignX = this.getValueAlignmentX();
        double alignY = this.getValueAlignmentY();
        double rotation = this.getValueRotation();
        double distance = this.getValueDistance();
        distance = MathUtils.isCalculatable(distance) ? (distance *= fontSize) : 0.0;
        Label label = new Label(text);
        label.setAlignmentX(alignX);
        label.setAlignmentY(alignY);
        label.setRotation(rotation);
        label.setColor(paint);
        label.setFont(font);
        Rectangle2D boundsPoint = point.getBounds2D();
        DrawableContainer labelContainer = new DrawableContainer(new OuterEdgeLayout(distance));
        labelContainer.add(label, (Object)location);
        labelContainer.setBounds(boundsPoint);
        labelContainer.draw(context);
    }

    protected void drawErrorBars(DrawingContext context, Shape point, Row row, int rowIndex, int col, int colErrorTop, int colErrorBottom, Axis axis, AxisRenderer axisRenderer) {
        if (axisRenderer == null) {
            return;
        }
        if (colErrorTop < 0 || colErrorTop >= row.size() || !row.isColumnNumeric(colErrorTop) || colErrorBottom < 0 || colErrorBottom >= row.size() || !row.isColumnNumeric(colErrorBottom)) {
            return;
        }
        Number value = (Number)((Object)row.get(col));
        Number errorTop = (Number)((Object)row.get(colErrorTop));
        Number errorBottom = (Number)((Object)row.get(colErrorBottom));
        if (!(MathUtils.isCalculatable(value) && MathUtils.isCalculatable(errorTop) && MathUtils.isCalculatable(errorBottom))) {
            return;
        }
        Graphics2D graphics = context.getGraphics();
        AffineTransform txOld = graphics.getTransform();
        PointND<Double> pointValue = axisRenderer.getPosition(axis, value, true, false);
        PointND<Double> pointTop = axisRenderer.getPosition(axis, value.doubleValue() + errorTop.doubleValue(), true, false);
        PointND<Double> pointBottom = axisRenderer.getPosition(axis, value.doubleValue() - errorBottom.doubleValue(), true, false);
        if (pointValue == null || pointTop == null || pointBottom == null) {
            return;
        }
        double posY = pointValue.get(1);
        double posYTop = pointTop.get(1) - posY;
        double posYBottom = pointBottom.get(1) - posY;
        Line2D.Double errorBar = new Line2D.Double(0.0, posYTop, 0.0, posYBottom);
        ColorMapper colors = this.getErrorColor();
        Paint errorPaint = colors.get(rowIndex);
        Stroke errorStroke = this.getErrorStroke();
        GraphicsUtils.drawPaintedShape(graphics, errorBar, errorPaint, null, errorStroke);
        Shape endShape = this.getErrorShape();
        graphics.translate(0.0, posYTop);
        BasicStroke endShapeStroke = new BasicStroke(1.0f);
        GraphicsUtils.drawPaintedShape(graphics, endShape, errorPaint, null, endShapeStroke);
        graphics.setTransform(txOld);
        graphics.translate(0.0, posYBottom);
        GraphicsUtils.drawPaintedShape(graphics, endShape, errorPaint, null, endShapeStroke);
        graphics.setTransform(txOld);
    }

    @Override
    public Shape getPointShape(PointData data) {
        return this.getShape();
    }

    @Override
    public Drawable getValue(final PointData data, final Shape shape) {
        AbstractDrawable drawable = new AbstractDrawable(){
            private static final long serialVersionUID = -2568531344817590175L;

            @Override
            public void draw(DrawingContext context) {
                DefaultPointRenderer2D renderer = DefaultPointRenderer2D.this;
                Row row = data.row;
                if (renderer.isValueVisible()) {
                    int colValue = renderer.getValueColumn();
                    DefaultPointRenderer2D.this.drawValueLabel(context, shape, row, data.index, colValue);
                }
            }
        };
        return drawable;
    }
}

