/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.lines;

import de.erichseifert.gral.plots.lines.LineRenderer;
import de.erichseifert.gral.util.SerializationUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class AbstractLineRenderer2D
implements LineRenderer,
Serializable {
    private static final long serialVersionUID = -4172505541305453796L;
    private transient Stroke stroke = new BasicStroke(1.5f);
    private double gap = 0.0;
    private boolean gapRounded = false;
    private Paint color = Color.BLACK;

    protected Shape stroke(Shape line) {
        if (line == null) {
            return null;
        }
        Stroke stroke = this.getStroke();
        Shape lineShape = stroke.createStrokedShape(line);
        return lineShape;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.stroke = (Stroke)SerializationUtils.unwrap((Serializable)in.readObject());
    }

    private void writeObject(ObjectOutputStream out) throws ClassNotFoundException, IOException {
        out.defaultWriteObject();
        out.writeObject(SerializationUtils.wrap(this.stroke));
    }

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    @Override
    public double getGap() {
        return this.gap;
    }

    @Override
    public void setGap(double gap) {
        this.gap = gap;
    }

    @Override
    public boolean isGapRounded() {
        return this.gapRounded;
    }

    @Override
    public void setGapRounded(boolean gapRounded) {
        this.gapRounded = gapRounded;
    }

    @Override
    public Paint getColor() {
        return this.color;
    }

    @Override
    public void setColor(Paint color) {
        this.color = color;
    }
}

