/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.legends;

import de.erichseifert.gral.data.DataChangeEvent;
import de.erichseifert.gral.data.DataListener;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.Row;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.plots.legends.AbstractLegend;
import java.awt.Font;
import java.text.Format;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;

public abstract class ValueLegend
extends AbstractLegend
implements DataListener {
    private static final long serialVersionUID = -4274009997506638823L;
    private final Map<Row, Drawable> components = new HashMap<Row, Drawable>();
    private int labelColumn = 0;
    private Format labelFormat;

    protected Iterable<Row> getEntries(DataSource source) {
        LinkedList<Row> items = new LinkedList<Row>();
        for (int rowIndex = 0; rowIndex < source.getRowCount(); ++rowIndex) {
            Row row = new Row(source, rowIndex);
            items.add(row);
        }
        return items;
    }

    protected String getLabel(Row row) {
        int col = this.getLabelColumn();
        Comparable<?> value = row.get(col);
        if (value == null) {
            return "";
        }
        Format format = this.getLabelFormat();
        if (format == null && row.isColumnNumeric(col)) {
            format = NumberFormat.getInstance();
        }
        String text = format != null ? format.format(value) : value.toString();
        return text;
    }

    @Override
    public void add(DataSource source) {
        super.add(source);
        this.refresh();
        source.addDataListener(this);
    }

    @Override
    public void remove(DataSource source) {
        super.remove(source);
        HashSet<Row> rows = new HashSet<Row>(this.components.keySet());
        for (Row row : rows) {
            Drawable item;
            if (row.getSource() != source || (item = this.components.remove(row)) == null) continue;
            this.remove(item);
        }
        this.refresh();
        source.removeDataListener(this);
    }

    @Override
    public void dataAdded(DataSource source, DataChangeEvent ... events) {
        this.dataChanged(source, events);
    }

    @Override
    public void dataUpdated(DataSource source, DataChangeEvent ... events) {
        this.dataChanged(source, events);
    }

    @Override
    public void dataRemoved(DataSource source, DataChangeEvent ... events) {
        this.dataChanged(source, events);
    }

    private void dataChanged(DataSource source, DataChangeEvent ... events) {
        this.refresh();
    }

    public int getLabelColumn() {
        return this.labelColumn;
    }

    public void setLabelColumn(int labelColumn) {
        this.labelColumn = labelColumn;
        this.refresh();
    }

    public Format getLabelFormat() {
        return this.labelFormat;
    }

    public void setLabelFormat(Format labelFormat) {
        this.labelFormat = labelFormat;
        this.refresh();
    }

    protected abstract Drawable getSymbol(Row var1);

    private void refresh() {
        for (Drawable drawable : this.components.values()) {
            this.remove(drawable);
        }
        this.components.clear();
        for (DataSource source : this.getSources()) {
            for (Row row : this.getEntries(source)) {
                String label = this.getLabel(row);
                Font font = this.getFont();
                AbstractLegend.Item item = new AbstractLegend.Item(this.getSymbol(row), label, font);
                this.add(item);
                this.components.put(row, item);
            }
        }
    }
}

