/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.legends;

import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.plots.legends.AbstractLegend;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;

public abstract class SeriesLegend
extends AbstractLegend {
    private static final long serialVersionUID = 1092110896986707546L;
    private final Map<DataSource, Drawable> drawableByDataSource = new HashMap<DataSource, Drawable>();

    @Override
    public void add(DataSource source) {
        super.add(source);
        String label = this.getLabel(source);
        Font font = this.getFont();
        AbstractLegend.Item item = new AbstractLegend.Item(this.getSymbol(source), label, font);
        this.add(item);
        this.drawableByDataSource.put(source, item);
    }

    @Override
    public void remove(DataSource source) {
        super.remove(source);
        Drawable drawable = this.drawableByDataSource.remove(source);
        if (drawable != null) {
            this.remove(drawable);
        }
    }

    protected String getLabel(DataSource data) {
        return data.toString();
    }

    protected abstract Drawable getSymbol(DataSource var1);
}

