/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.legends;

import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.graphics.AbstractDrawable;
import de.erichseifert.gral.graphics.Dimension2D;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawableContainer;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.graphics.Insets2D;
import de.erichseifert.gral.graphics.Label;
import de.erichseifert.gral.graphics.Location;
import de.erichseifert.gral.graphics.Orientation;
import de.erichseifert.gral.graphics.layout.EdgeLayout;
import de.erichseifert.gral.graphics.layout.Layout;
import de.erichseifert.gral.graphics.layout.OrientedLayout;
import de.erichseifert.gral.graphics.layout.StackedLayout;
import de.erichseifert.gral.plots.legends.Legend;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.SerializationUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class AbstractLegend
extends DrawableContainer
implements Legend {
    private static final long serialVersionUID = -1561976879958765700L;
    private final Set<DataSource> sources;
    private Font baseFont;
    private Paint background;
    private transient Stroke borderStroke;
    private Font font;
    private Paint borderColor;
    private Orientation orientation;
    private double alignmentX;
    private double alignmentY;
    private Dimension2D gap;
    private Dimension2D symbolSize;

    public AbstractLegend() {
        this.setInsets(new Insets2D.Double(10.0));
        this.sources = new LinkedHashSet<DataSource>();
        this.background = Color.WHITE;
        this.borderStroke = new BasicStroke(1.0f);
        this.font = Font.decode(null);
        this.setDrawableFonts(this.font);
        this.borderColor = Color.BLACK;
        this.orientation = Orientation.VERTICAL;
        this.alignmentX = 0.0;
        this.alignmentY = 0.0;
        this.setGap(new Dimension2D.Double(2.0, 0.5));
        this.symbolSize = new Dimension2D.Double(2.0, 2.0);
        this.setLayout(new StackedLayout(this.orientation, this.gap.getWidth(), this.gap.getHeight()));
        this.refreshLayout();
    }

    @Override
    public void draw(DrawingContext context) {
        this.drawBackground(context);
        this.drawBorder(context);
        this.drawComponents(context);
    }

    protected void drawBackground(DrawingContext context) {
        Paint background = this.getBackground();
        if (background != null) {
            GraphicsUtils.fillPaintedShape(context.getGraphics(), this.getBounds(), background, null);
        }
    }

    protected void drawBorder(DrawingContext context) {
        Stroke stroke = this.getBorderStroke();
        if (stroke != null) {
            Paint borderColor = this.getBorderColor();
            GraphicsUtils.drawPaintedShape(context.getGraphics(), this.getBounds(), borderColor, null, stroke);
        }
    }

    @Override
    public void add(DataSource source) {
        this.sources.add(source);
    }

    @Override
    public boolean contains(DataSource source) {
        return this.sources.contains(source);
    }

    @Override
    public void remove(DataSource source) {
        this.sources.remove(source);
    }

    public Set<DataSource> getSources() {
        return Collections.unmodifiableSet(this.sources);
    }

    @Override
    public void clear() {
        HashSet<DataSource> sources = new HashSet<DataSource>(this.sources);
        for (DataSource source : sources) {
            this.remove(source);
        }
    }

    protected final void refreshLayout() {
        Dimension2D gap = this.getGap();
        Layout layout = this.getLayout();
        layout.setGapX(gap.getWidth());
        layout.setGapY(gap.getHeight());
        if (layout instanceof OrientedLayout) {
            OrientedLayout orientedLayout = (OrientedLayout)layout;
            orientedLayout.setOrientation(this.getOrientation());
        }
    }

    @Override
    public void setBounds(double x, double y, double width, double height) {
        Dimension2D size = this.getPreferredSize();
        double alignX = this.getAlignmentX();
        double alignY = this.getAlignmentY();
        super.setBounds(x + alignX * (width - size.getWidth()), y + alignY * (height - size.getHeight()), size.getWidth(), size.getHeight());
    }

    protected final void setDrawableFonts(Font font) {
        for (Drawable drawable : this) {
            if (!(drawable instanceof Item)) continue;
            Item item = (Item)drawable;
            item.label.setFont(font);
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.borderStroke = (Stroke)SerializationUtils.unwrap((Serializable)in.readObject());
    }

    private void writeObject(ObjectOutputStream out) throws ClassNotFoundException, IOException {
        out.defaultWriteObject();
        out.writeObject(SerializationUtils.wrap(this.borderStroke));
    }

    @Override
    public Font getBaseFont() {
        return this.baseFont;
    }

    @Override
    public void setBaseFont(Font baseFont) {
        this.baseFont = baseFont;
    }

    @Override
    public Paint getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(Paint background) {
        this.background = background;
    }

    @Override
    public Stroke getBorderStroke() {
        return this.borderStroke;
    }

    @Override
    public void setBorderStroke(Stroke borderStroke) {
        this.borderStroke = borderStroke;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
        this.setDrawableFonts(font);
    }

    @Override
    public Paint getBorderColor() {
        return this.borderColor;
    }

    @Override
    public void setBorderColor(Paint borderColor) {
        this.borderColor = borderColor;
    }

    @Override
    public Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.refreshLayout();
    }

    @Override
    public double getAlignmentX() {
        return this.alignmentX;
    }

    @Override
    public void setAlignmentX(double alignmentX) {
        this.alignmentX = alignmentX;
    }

    @Override
    public double getAlignmentY() {
        return this.alignmentY;
    }

    @Override
    public void setAlignmentY(double alignmentY) {
        this.alignmentY = alignmentY;
    }

    @Override
    public Dimension2D getGap() {
        return this.gap;
    }

    @Override
    public void setGap(Dimension2D gap) {
        this.gap = gap;
        if (this.gap != null) {
            double fontSize = this.getFont().getSize2D();
            this.gap.setSize(this.gap.getWidth() * fontSize, this.gap.getHeight() * fontSize);
        }
    }

    @Override
    public Dimension2D getSymbolSize() {
        return this.symbolSize;
    }

    @Override
    public void setSymbolSize(Dimension2D symbolSize) {
        this.symbolSize = symbolSize;
    }

    public static class Item
    extends DrawableContainer {
        private static final long serialVersionUID = 3401141040936913098L;
        private Font baseFont;
        private final Drawable symbol;
        private final Label label;

        public Item(Drawable symbol, String labelText, Font font) {
            double fontSize = font.getSize2D();
            this.setLayout(new EdgeLayout(fontSize, 0.0));
            this.symbol = symbol;
            this.add(symbol, (Object)Location.WEST);
            this.label = new Label(labelText);
            this.label.setFont(font);
            this.label.setAlignmentX(0.0);
            this.label.setAlignmentY(0.5);
            this.add(this.label, (Object)Location.CENTER);
        }

        public Label getLabel() {
            return this.label;
        }

        public Drawable getSymbol() {
            return this.symbol;
        }
    }

    public static abstract class AbstractSymbol
    extends AbstractDrawable {
        private static final long serialVersionUID = 7475404103140652668L;
        private final Font font;
        private final Dimension2D symbolSize;

        public AbstractSymbol(Font font, Dimension2D symbolSize) {
            this.font = font;
            this.symbolSize = symbolSize;
        }

        @Override
        public Dimension2D getPreferredSize() {
            double fontSize = this.font.getSize2D();
            Dimension2D size = super.getPreferredSize();
            size.setSize(this.symbolSize.getWidth() * fontSize, this.symbolSize.getHeight() * fontSize);
            return size;
        }
    }
}

