/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.colors;

import de.erichseifert.gral.plots.colors.IndexedColorMapper;
import de.erichseifert.gral.util.HaltonSequence;
import de.erichseifert.gral.util.MathUtils;
import java.awt.Color;
import java.awt.Paint;
import java.util.HashMap;
import java.util.Map;

public class QuasiRandomColors
extends IndexedColorMapper {
    private static final long serialVersionUID = 3320256963368776894L;
    private final HaltonSequence seqHue = new HaltonSequence(3);
    private final HaltonSequence seqSat = new HaltonSequence(5);
    private final HaltonSequence seqBrightness = new HaltonSequence(2);
    private final Map<Integer, Color> colorCache = new HashMap<Integer, Color>();
    private float[] colorVariance = new float[]{0.0f, 1.0f, 0.75f, 0.25f, 0.25f, 0.75f};

    @Override
    public Paint get(int index) {
        Integer key = index;
        if (this.colorCache.containsKey(key)) {
            return this.colorCache.get(key);
        }
        float[] colorVariance = this.getColorVariance();
        float hue = colorVariance[0] + colorVariance[1] * this.seqHue.next().floatValue();
        float saturation = colorVariance[2] + colorVariance[3] * this.seqSat.next().floatValue();
        float brightness = colorVariance[4] + colorVariance[5] * this.seqBrightness.next().floatValue();
        Color color = Color.getHSBColor(hue, MathUtils.limit(saturation, 0.0f, 1.0f), MathUtils.limit(brightness, 0.0f, 1.0f));
        this.colorCache.put(key, color);
        return color;
    }

    public float[] getColorVariance() {
        return this.colorVariance;
    }

    public void setColorVariance(float[] colorVariance) {
        this.colorVariance = colorVariance;
    }
}

