/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.axes;

import de.erichseifert.gral.plots.axes.AxisListener;
import de.erichseifert.gral.util.MathUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class Axis
implements Serializable {
    private static final long serialVersionUID = 5355772833362614591L;
    private transient Set<AxisListener> axisListeners = new HashSet<AxisListener>();
    private Number min;
    private Number max;
    private boolean autoscaled;

    private Axis(boolean autoscaled) {
        this.autoscaled = autoscaled;
    }

    public Axis() {
        this(true);
    }

    public Axis(Number min, Number max) {
        this(false);
        this.min = min;
        this.max = max;
    }

    public void addAxisListener(AxisListener listener) {
        this.axisListeners.add(listener);
    }

    public void removeAxisListener(AxisListener listener) {
        this.axisListeners.remove(listener);
    }

    private void fireRangeChanged(Number min, Number max) {
        for (AxisListener listener : this.axisListeners) {
            listener.rangeChanged(this, min, max);
        }
    }

    public Number getMin() {
        return this.min;
    }

    public void setMin(Number min) {
        this.setRange(min, this.getMax());
    }

    public Number getMax() {
        return this.max;
    }

    public void setMax(Number max) {
        this.setRange(this.getMin(), max);
    }

    public double getRange() {
        return this.getMax().doubleValue() - this.getMin().doubleValue();
    }

    public void setRange(Number min, Number max) {
        if (this.getMin() != null && this.getMin().equals(min) && this.getMax() != null && this.getMax().equals(max)) {
            return;
        }
        this.min = min;
        this.max = max;
        this.fireRangeChanged(min, max);
    }

    public Number getPosition(Number value) {
        if (value == null) {
            return null;
        }
        double relativePosition = (value.doubleValue() - this.getMin().doubleValue()) / this.getRange();
        return relativePosition;
    }

    public boolean isAutoscaled() {
        return this.autoscaled;
    }

    public void setAutoscaled(boolean autoscaled) {
        this.autoscaled = autoscaled;
    }

    public boolean isValid() {
        return MathUtils.isCalculatable(this.min) && MathUtils.isCalculatable(this.max);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.axisListeners = new HashSet<AxisListener>();
    }
}

