/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.axes;

import de.erichseifert.gral.graphics.AbstractDrawable;
import de.erichseifert.gral.graphics.Dimension2D;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.graphics.Label;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.plots.axes.Tick;
import de.erichseifert.gral.util.GeometryUtils;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.MathUtils;
import de.erichseifert.gral.util.PointND;
import de.erichseifert.gral.util.SerializationUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractAxisRenderer2D
implements AxisRenderer,
Serializable {
    private static final long serialVersionUID = 5623525683845512624L;
    private Line2D[] shapeLines;
    private Point2D[] shapeLineNormals;
    private double[] shapeSegmentLengths;
    private double[] shapeSegmentLengthsAccumulated;
    private Number intersection = 0.0;
    private Shape shape = new Line2D.Double(0.0, 0.0, 1.0, 0.0);
    private boolean shapeVisible;
    private boolean shapeNormalOrientationClockwise;
    private Paint shapeColor;
    private transient Stroke shapeStroke;
    private boolean shapeDirectionSwapped = false;
    private boolean ticksVisible;
    private Number tickSpacing;
    private boolean ticksAutoSpaced;
    private double tickLength;
    private transient Stroke tickStroke;
    private double tickAlignment;
    private Font tickFont;
    private Paint tickColor;
    private boolean tickLabelsVisible;
    private Format tickLabelFormat;
    private double tickLabelDistance;
    private boolean tickLabelsOutside;
    private double tickLabelRotation;
    private boolean minorTickVisible;
    private int minorTicksCount;
    private double minorTickLength;
    private transient Stroke minorTickStroke;
    private double minorTickAlignment;
    private Paint minorTickColor;
    private final Map<Double, String> customTicks;
    private Label label;
    private double labelDistance;

    public AbstractAxisRenderer2D() {
        this.evaluateShape(this.shape);
        this.shapeVisible = true;
        this.shapeNormalOrientationClockwise = false;
        this.shapeStroke = new BasicStroke();
        this.shapeColor = Color.BLACK;
        this.ticksVisible = true;
        this.tickSpacing = 0.0;
        this.ticksAutoSpaced = false;
        this.tickLength = 1.0;
        this.tickStroke = new BasicStroke();
        this.tickAlignment = 0.5;
        this.tickFont = Font.decode(null);
        this.tickColor = Color.BLACK;
        this.tickLabelsVisible = true;
        this.tickLabelFormat = NumberFormat.getInstance();
        this.tickLabelDistance = 1.0;
        this.tickLabelsOutside = true;
        this.tickLabelRotation = 0.0;
        this.customTicks = new HashMap<Double, String>();
        this.minorTickVisible = true;
        this.minorTicksCount = 1;
        this.minorTickLength = 0.5;
        this.minorTickStroke = new BasicStroke();
        this.minorTickAlignment = 0.5;
        this.minorTickColor = Color.BLACK;
        this.label = new Label();
        this.labelDistance = 1.0;
    }

    @Override
    public Drawable getRendererComponent(final Axis axis) {
        AbstractDrawable component = new AbstractDrawable(){
            private static final long serialVersionUID = 3605211198378801694L;

            @Override
            public void draw(DrawingContext context) {
                Label axisLabel;
                if (AbstractAxisRenderer2D.this.shapeLines == null || AbstractAxisRenderer2D.this.shapeLines.length == 0) {
                    return;
                }
                AbstractAxisRenderer2D renderer = AbstractAxisRenderer2D.this;
                Graphics2D graphics = context.getGraphics();
                AffineTransform txOrig = graphics.getTransform();
                graphics.translate(this.getX(), this.getY());
                Stroke strokeOld = graphics.getStroke();
                Paint paintOld = graphics.getPaint();
                Paint axisPaint = renderer.getShapeColor();
                Stroke axisStroke = renderer.getShapeStroke();
                boolean isShapeVisible = renderer.isShapeVisible();
                if (isShapeVisible) {
                    Shape shape = renderer.getShape();
                    GraphicsUtils.drawPaintedShape(graphics, shape, axisPaint, null, axisStroke);
                }
                double fontSize = renderer.getTickFont().getSize2D();
                boolean drawTicksMajor = renderer.isTicksVisible();
                boolean drawTicksMinor = renderer.isMinorTicksVisible();
                if (drawTicksMajor || drawTicksMajor && drawTicksMinor) {
                    List<Tick> ticks = AbstractAxisRenderer2D.this.getTicks(axis);
                    boolean isTickLabelVisible = renderer.isTickLabelsVisible();
                    boolean isTickLabelOutside = renderer.isTickLabelsOutside();
                    double tickLabelRotation = renderer.getTickLabelRotation();
                    double tickLabelDist = renderer.getTickLabelDistanceAbsolute();
                    Line2D.Double tickShape = new Line2D.Double();
                    for (Tick tick : ticks) {
                        String tickLabelText;
                        Stroke tickStroke;
                        Paint tickPaint;
                        double tickAlignment;
                        double tickLength;
                        if (tick.position == null || tick.normal == null) continue;
                        Point2D tickPoint = tick.position.getPoint2D();
                        Point2D tickNormal = tick.normal.getPoint2D();
                        if (Tick.TickType.MINOR.equals((Object)tick.type)) {
                            tickLength = renderer.getTickMinorLengthAbsolute();
                            tickAlignment = renderer.getMinorTickAlignment();
                            tickPaint = renderer.getMinorTickColor();
                            tickStroke = renderer.getMinorTickStroke();
                        } else {
                            tickLength = AbstractAxisRenderer2D.this.getTickLengthAbsolute();
                            tickAlignment = renderer.getTickAlignment();
                            tickPaint = renderer.getTickColor();
                            tickStroke = renderer.getTickStroke();
                        }
                        double tickLengthInner = tickLength * tickAlignment;
                        double tickLengthOuter = tickLength * (1.0 - tickAlignment);
                        if (drawTicksMajor && tick.type == Tick.TickType.MAJOR || tick.type == Tick.TickType.CUSTOM || drawTicksMinor && tick.type == Tick.TickType.MINOR) {
                            ((Line2D)tickShape).setLine(tickPoint.getX() - tickNormal.getX() * tickLengthInner, tickPoint.getY() - tickNormal.getY() * tickLengthInner, tickPoint.getX() + tickNormal.getX() * tickLengthOuter, tickPoint.getY() + tickNormal.getY() * tickLengthOuter);
                            GraphicsUtils.drawPaintedShape(graphics, tickShape, tickPaint, null, tickStroke);
                        }
                        if (!isTickLabelVisible || tick.type != Tick.TickType.MAJOR && tick.type != Tick.TickType.CUSTOM || (tickLabelText = tick.label) == null || tickLabelText.trim().isEmpty()) continue;
                        Label tickLabel = new Label(tickLabelText);
                        tickLabel.setFont(renderer.getTickFont());
                        tickLabel.setColor(tickPaint);
                        double labelDist = tickLengthOuter + tickLabelDist;
                        this.layoutLabel(tickLabel, tickPoint, tickNormal, labelDist, isTickLabelOutside, tickLabelRotation);
                        tickLabel.draw(context);
                    }
                }
                if ((axisLabel = renderer.getLabel()) != null && !axisLabel.getText().trim().isEmpty()) {
                    double tickLength = AbstractAxisRenderer2D.this.getTickLengthAbsolute();
                    double tickAlignment = renderer.getTickAlignment();
                    double tickLengthOuter = tickLength * (1.0 - tickAlignment);
                    double tickLabelDistance = renderer.getTickLabelDistanceAbsolute();
                    double labelDistance = renderer.getLabelDistance() * fontSize;
                    double labelDist = tickLengthOuter + tickLabelDistance + fontSize + labelDistance;
                    double axisLabelPos = (axis.getMin().doubleValue() + axis.getMax().doubleValue()) * 0.5;
                    boolean isTickLabelOutside = renderer.isTickLabelsOutside();
                    PointND<Double> labelPos = AbstractAxisRenderer2D.this.getPosition(axis, axisLabelPos, false, true);
                    PointND<Double> labelNormal = AbstractAxisRenderer2D.this.getNormal(axis, axisLabelPos, false, true);
                    if (labelPos != null && labelNormal != null) {
                        this.layoutLabel(axisLabel, labelPos.getPoint2D(), labelNormal.getPoint2D(), labelDist, isTickLabelOutside, axisLabel.getRotation());
                        axisLabel.draw(context);
                    }
                }
                graphics.setPaint(paintOld);
                graphics.setStroke(strokeOld);
                graphics.setTransform(txOrig);
            }

            private void layoutLabel(Label label, Point2D labelPos, Point2D labelNormal, double labelDist, boolean isLabelOutside, double rotation) {
                Rectangle2D labelSize = label.getTextRectangle();
                Shape marginShape = new Rectangle2D.Double(0.0, 0.0, labelSize.getWidth() + 2.0 * labelDist, labelSize.getHeight() + 2.0 * labelDist);
                Rectangle2D marginBounds = marginShape.getBounds2D();
                label.setRotation(rotation);
                if (rotation % 360.0 != 0.0) {
                    marginShape = AffineTransform.getRotateInstance(Math.toRadians(-rotation), marginBounds.getCenterX(), marginBounds.getCenterY()).createTransformedShape(marginShape);
                }
                marginBounds = marginShape.getBounds2D();
                double intersRayLength = marginBounds.getHeight() * marginBounds.getHeight() + marginBounds.getWidth() * marginBounds.getWidth();
                double intersRayDir = (isLabelOutside ? -1.0 : 1.0) * intersRayLength;
                List<Point2D> descriptionBoundsIntersections = GeometryUtils.intersection(marginBounds, (Shape)new Line2D.Double(marginBounds.getCenterX(), marginBounds.getCenterY(), marginBounds.getCenterX() + intersRayDir * labelNormal.getX(), marginBounds.getCenterY() + intersRayDir * labelNormal.getY()));
                if (!descriptionBoundsIntersections.isEmpty()) {
                    Point2D inters = descriptionBoundsIntersections.get(0);
                    double intersX = inters.getX() - marginBounds.getCenterX();
                    double intersY = inters.getY() - marginBounds.getCenterY();
                    double posX = labelPos.getX() - intersX - labelSize.getWidth() / 2.0;
                    double posY = labelPos.getY() - intersY - labelSize.getHeight() / 2.0;
                    label.setBounds(posX, posY, labelSize.getWidth(), labelSize.getHeight());
                }
            }

            @Override
            public Dimension2D getPreferredSize() {
                AbstractAxisRenderer2D renderer = AbstractAxisRenderer2D.this;
                double fontSize = renderer.getTickFont().getSize2D();
                double tickLength = AbstractAxisRenderer2D.this.getTickLengthAbsolute();
                double tickAlignment = renderer.getTickAlignment();
                double tickLengthOuter = tickLength * (1.0 - tickAlignment);
                double labelDistance = renderer.getTickLabelDistanceAbsolute() + tickLengthOuter;
                double minSize = fontSize + labelDistance + tickLengthOuter;
                return new Dimension2D.Double(minSize, minSize);
            }
        };
        return component;
    }

    @Override
    public List<Tick> getTicks(Axis axis) {
        LinkedList<Tick> ticks = new LinkedList<Tick>();
        if (!axis.isValid()) {
            return ticks;
        }
        double min = axis.getMin().doubleValue();
        double max = axis.getMax().doubleValue();
        HashSet<Double> tickPositions = new HashSet<Double>();
        this.createTicksCustom(ticks, axis, min, max, tickPositions);
        boolean isAutoSpacing = this.isTicksAutoSpaced();
        if (!isAutoSpacing) {
            Number tickSpacing = this.getTickSpacing();
            if (tickSpacing == null) {
                isAutoSpacing = true;
            } else {
                double tickSpacingValue = tickSpacing.doubleValue();
                if (tickSpacingValue <= 0.0 || !MathUtils.isCalculatable(tickSpacingValue)) {
                    isAutoSpacing = true;
                }
            }
        }
        this.createTicks(ticks, axis, min, max, tickPositions, isAutoSpacing);
        return ticks;
    }

    protected double getTickLengthAbsolute() {
        double fontSize = this.getTickFont().getSize2D();
        return this.getTickLength() * fontSize;
    }

    protected double getTickMinorLengthAbsolute() {
        double fontSize = this.getTickFont().getSize2D();
        return this.getMinorTickLength() * fontSize;
    }

    protected double getTickLabelDistanceAbsolute() {
        double fontSize = this.getTickFont().getSize2D();
        return this.getTickLabelDistance() * fontSize;
    }

    protected abstract void createTicks(List<Tick> var1, Axis var2, double var3, double var5, Set<Double> var7, boolean var8);

    protected void createTicksCustom(List<Tick> ticks, Axis axis, double min, double max, Set<Double> tickPositions) {
        Map<Double, String> labelsCustom = this.getCustomTicks();
        if (labelsCustom != null) {
            for (Number number : labelsCustom.keySet()) {
                double tickPositionWorld = number.doubleValue();
                if (tickPositionWorld < min || tickPositionWorld > max) continue;
                Tick tick = this.getTick(Tick.TickType.CUSTOM, axis, tickPositionWorld);
                ticks.add(tick);
                tickPositions.add(tickPositionWorld);
            }
        }
    }

    protected Tick getTick(Tick.TickType type, Axis axis, double tickPositionWorld) {
        Format labelFormat;
        PointND<Double> tickPoint = this.getPosition(axis, tickPositionWorld, false, false);
        PointND<Double> tickNormal = this.getNormal(axis, tickPositionWorld, false, false);
        Map<Double, String> labelsCustom = this.getCustomTicks();
        String tickLabel = labelsCustom != null && labelsCustom.containsKey(tickPositionWorld) ? labelsCustom.get(tickPositionWorld) : ((labelFormat = this.getTickLabelFormat()) != null ? labelFormat.format(tickPositionWorld) : String.valueOf(tickPositionWorld));
        Tick tick = new Tick(type, tickPoint, tickNormal, null, null, tickLabel);
        return tick;
    }

    @Override
    public PointND<Double> getNormal(Axis axis, Number value, boolean extrapolate, boolean forceLinear) {
        double valueView = forceLinear ? (value.doubleValue() - axis.getMin().doubleValue()) / axis.getRange() * this.getShapeLength() : this.worldToView(axis, value, extrapolate);
        int segmentIndex = MathUtils.binarySearchFloor(this.shapeSegmentLengthsAccumulated, valueView);
        if (segmentIndex < 0 || segmentIndex >= this.shapeLines.length) {
            return null;
        }
        segmentIndex = MathUtils.limit(segmentIndex, 0, this.shapeLineNormals.length - 1);
        boolean normalOrientationClockwise = this.isShapeNormalOrientationClockwise();
        double normalOrientation = normalOrientationClockwise ? 1.0 : -1.0;
        PointND tickNormal = new PointND((Number[])new Double[]{normalOrientation * this.shapeLineNormals[segmentIndex].getX(), normalOrientation * this.shapeLineNormals[segmentIndex].getY()});
        return tickNormal;
    }

    protected double getShapeLength() {
        if (this.shapeSegmentLengthsAccumulated == null || this.shapeSegmentLengthsAccumulated.length == 0) {
            return 0.0;
        }
        return this.shapeSegmentLengthsAccumulated[this.shapeSegmentLengthsAccumulated.length - 1];
    }

    @Override
    public PointND<Double> getPosition(Axis axis, Number value, boolean extrapolate, boolean forceLinear) {
        double positionOnShapePath;
        if (this.shapeLines == null || this.shapeLines.length == 0 || value == null) {
            return null;
        }
        double relativePositionOnShapePath = axis.getPosition(value).doubleValue();
        if (!extrapolate) {
            relativePositionOnShapePath = MathUtils.limit(relativePositionOnShapePath, 0.0, 1.0);
        }
        if (Double.isNaN(positionOnShapePath = forceLinear ? relativePositionOnShapePath * this.getShapeLength() : this.worldToView(axis, value, extrapolate))) {
            return null;
        }
        if (positionOnShapePath == Double.NEGATIVE_INFINITY) {
            positionOnShapePath = 0.0;
        } else if (positionOnShapePath == Double.POSITIVE_INFINITY) {
            positionOnShapePath = 1.0;
        }
        int segmentIndex = relativePositionOnShapePath <= 0.0 ? 0 : (relativePositionOnShapePath >= 1.0 ? this.shapeLines.length - 1 : MathUtils.binarySearchFloor(this.shapeSegmentLengthsAccumulated, positionOnShapePath));
        if (segmentIndex < 0 || segmentIndex >= this.shapeLines.length) {
            return null;
        }
        Line2D segment = this.shapeLines[segmentIndex];
        double segmentLen = this.shapeSegmentLengths[segmentIndex];
        double segmentLenAcc = this.shapeSegmentLengthsAccumulated[segmentIndex];
        double relLen = (positionOnShapePath - segmentLenAcc) / segmentLen;
        double x = segment.getX1() + (segment.getX2() - segment.getX1()) * relLen;
        double y = segment.getY1() + (segment.getY2() - segment.getY1()) * relLen;
        return new PointND((Number[])new Double[]{x, y});
    }

    protected final void evaluateShape(Shape shape) {
        boolean directionSwapped = this.isShapeDirectionSwapped();
        this.shapeLines = GeometryUtils.shapeToLines(shape, directionSwapped);
        this.shapeSegmentLengths = new double[this.shapeLines.length];
        this.shapeSegmentLengthsAccumulated = new double[this.shapeLines.length + 1];
        this.shapeLineNormals = new Point2D[this.shapeLines.length];
        if (this.shapeLines.length == 0) {
            return;
        }
        for (int i = 0; i < this.shapeLines.length; ++i) {
            double segmentLength;
            Line2D line = this.shapeLines[i];
            this.shapeSegmentLengths[i] = segmentLength = line.getP1().distance(line.getP2());
            this.shapeSegmentLengthsAccumulated[i + 1] = this.shapeSegmentLengthsAccumulated[i] + segmentLength;
            this.shapeLineNormals[i] = new Point2D.Double((line.getY2() - line.getY1()) / segmentLength, -(line.getX2() - line.getX1()) / segmentLength);
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.shapeStroke = (Stroke)SerializationUtils.unwrap((Serializable)in.readObject());
        this.tickStroke = (Stroke)SerializationUtils.unwrap((Serializable)in.readObject());
        this.minorTickStroke = (Stroke)SerializationUtils.unwrap((Serializable)in.readObject());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(SerializationUtils.wrap(this.shapeStroke));
        out.writeObject(SerializationUtils.wrap(this.tickStroke));
        out.writeObject(SerializationUtils.wrap(this.minorTickStroke));
    }

    @Override
    public Number getIntersection() {
        return this.intersection;
    }

    @Override
    public void setIntersection(Number intersection) {
        this.intersection = intersection;
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    @Override
    public void setShape(Shape shape) {
        this.shape = shape;
        this.evaluateShape(shape);
    }

    @Override
    public boolean isShapeVisible() {
        return this.shapeVisible;
    }

    @Override
    public void setShapeVisible(boolean shapeVisible) {
        this.shapeVisible = shapeVisible;
    }

    @Override
    public boolean isShapeNormalOrientationClockwise() {
        return this.shapeNormalOrientationClockwise;
    }

    @Override
    public void setShapeNormalOrientationClockwise(boolean clockwise) {
        this.shapeNormalOrientationClockwise = clockwise;
    }

    @Override
    public Paint getShapeColor() {
        return this.shapeColor;
    }

    @Override
    public void setShapeColor(Paint color) {
        this.shapeColor = color;
    }

    @Override
    public Stroke getShapeStroke() {
        return this.shapeStroke;
    }

    @Override
    public void setShapeStroke(Stroke stroke) {
        this.shapeStroke = stroke;
    }

    @Override
    public boolean isShapeDirectionSwapped() {
        return this.shapeDirectionSwapped;
    }

    @Override
    public void setShapeDirectionSwapped(boolean directionSwapped) {
        this.shapeDirectionSwapped = directionSwapped;
    }

    @Override
    public boolean isTicksVisible() {
        return this.ticksVisible;
    }

    @Override
    public void setTicksVisible(boolean ticksVisible) {
        this.ticksVisible = ticksVisible;
    }

    @Override
    public Number getTickSpacing() {
        return this.tickSpacing;
    }

    @Override
    public void setTickSpacing(Number spacing) {
        this.tickSpacing = spacing;
    }

    @Override
    public boolean isTicksAutoSpaced() {
        return this.ticksAutoSpaced;
    }

    @Override
    public void setTicksAutoSpaced(boolean autoSpaced) {
        this.ticksAutoSpaced = autoSpaced;
    }

    @Override
    public double getTickLength() {
        return this.tickLength;
    }

    @Override
    public void setTickLength(double length) {
        this.tickLength = length;
    }

    @Override
    public Stroke getTickStroke() {
        return this.tickStroke;
    }

    @Override
    public void setTickStroke(Stroke stroke) {
        this.tickStroke = stroke;
    }

    @Override
    public double getTickAlignment() {
        return this.tickAlignment;
    }

    @Override
    public void setTickAlignment(double alignment) {
        this.tickAlignment = alignment;
    }

    @Override
    public Font getTickFont() {
        return this.tickFont;
    }

    @Override
    public void setTickFont(Font font) {
        this.tickFont = font;
    }

    @Override
    public Paint getTickColor() {
        return this.tickColor;
    }

    @Override
    public void setTickColor(Paint color) {
        this.tickColor = color;
    }

    @Override
    public boolean isTickLabelsVisible() {
        return this.tickLabelsVisible;
    }

    @Override
    public void setTickLabelsVisible(boolean tickLabelsVisible) {
        this.tickLabelsVisible = tickLabelsVisible;
    }

    @Override
    public Format getTickLabelFormat() {
        return this.tickLabelFormat;
    }

    @Override
    public void setTickLabelFormat(Format format) {
        this.tickLabelFormat = format;
    }

    @Override
    public double getTickLabelDistance() {
        return this.tickLabelDistance;
    }

    @Override
    public void setTickLabelDistance(double distance) {
        this.tickLabelDistance = distance;
    }

    @Override
    public boolean isTickLabelsOutside() {
        return this.tickLabelsOutside;
    }

    @Override
    public void setTickLabelsOutside(boolean labelsOutside) {
        this.tickLabelsOutside = labelsOutside;
    }

    @Override
    public double getTickLabelRotation() {
        return this.tickLabelRotation;
    }

    @Override
    public void setTickLabelRotation(double angle) {
        this.tickLabelRotation = angle;
    }

    @Override
    public boolean isMinorTicksVisible() {
        return this.minorTickVisible;
    }

    @Override
    public void setMinorTicksVisible(boolean minorTicksVisible) {
        this.minorTickVisible = minorTicksVisible;
    }

    @Override
    public int getMinorTicksCount() {
        return this.minorTicksCount;
    }

    @Override
    public void setMinorTicksCount(int count) {
        this.minorTicksCount = count;
    }

    @Override
    public double getMinorTickLength() {
        return this.minorTickLength;
    }

    @Override
    public void setMinorTickLength(double length) {
        this.minorTickLength = length;
    }

    @Override
    public Stroke getMinorTickStroke() {
        return this.minorTickStroke;
    }

    @Override
    public void setMinorTickStroke(Stroke stroke) {
        this.minorTickStroke = stroke;
    }

    @Override
    public double getMinorTickAlignment() {
        return this.minorTickAlignment;
    }

    @Override
    public void setMinorTickAlignment(double alignment) {
        this.minorTickAlignment = alignment;
    }

    @Override
    public Paint getMinorTickColor() {
        return this.minorTickColor;
    }

    @Override
    public void setMinorTickColor(Paint color) {
        this.minorTickColor = color;
    }

    @Override
    public Map<Double, String> getCustomTicks() {
        return Collections.unmodifiableMap(this.customTicks);
    }

    @Override
    public void setCustomTicks(Map<Double, String> positionsAndLabels) {
        this.customTicks.clear();
        this.customTicks.putAll(positionsAndLabels);
    }

    @Override
    public Label getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(Label label) {
        this.label = label;
    }

    @Override
    public double getLabelDistance() {
        return this.labelDistance;
    }

    @Override
    public void setLabelDistance(double distance) {
        this.labelDistance = distance;
    }
}

