/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.areas;

import de.erichseifert.gral.graphics.AbstractDrawable;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.plots.DataPoint;
import de.erichseifert.gral.plots.areas.AbstractAreaRenderer;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.MathUtils;
import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.List;

public class LineAreaRenderer2D
extends AbstractAreaRenderer {
    private static final long serialVersionUID = -8396097579938931392L;
    private Stroke stroke = new BasicStroke(1.0f);

    @Override
    public Drawable getArea(List<DataPoint> points, final Shape shape) {
        return new AbstractDrawable(){
            private static final long serialVersionUID = 5492321759151727458L;

            @Override
            public void draw(DrawingContext context) {
                Paint paint = LineAreaRenderer2D.this.getColor();
                GraphicsUtils.fillPaintedShape(context.getGraphics(), shape, paint, null);
            }
        };
    }

    @Override
    public Shape getAreaShape(List<DataPoint> points) {
        if (points.isEmpty() || points.get(0) == null) {
            return null;
        }
        Axis axisY = points.get((int)0).data.axes.get(1);
        AxisRenderer axisRendererY = points.get((int)0).data.axisRenderers.get(1);
        double axisYMin = axisY.getMin().doubleValue();
        double axisYMax = axisY.getMax().doubleValue();
        double axisYOrigin = MathUtils.limit(0.0, axisYMin, axisYMax);
        double posYOrigin = 0.0;
        if (axisRendererY != null) {
            posYOrigin = axisRendererY.getPosition(axisY, axisYOrigin, true, false).get(1);
        }
        Path2D.Double shape = new Path2D.Double();
        double x = 0.0;
        double y = 0.0;
        for (DataPoint p : points) {
            Point2D pos = p.position.getPoint2D();
            x = pos.getX();
            y = pos.getY();
            ((Path2D)shape).moveTo(x, y);
            ((Path2D)shape).lineTo(x, posYOrigin);
        }
        Stroke stroke = this.getStroke();
        return stroke.createStrokedShape(shape);
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }
}

