/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots;

import de.erichseifert.gral.graphics.AbstractDrawable;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.graphics.Insets2D;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.SerializationUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class PlotArea
extends AbstractDrawable {
    private static final long serialVersionUID = 2745982325709470005L;
    private Font baseFont = null;
    private Paint background = Color.WHITE;
    private transient Stroke borderStroke = new BasicStroke(1.0f);
    private Paint borderColor = Color.BLACK;
    private Insets2D clippingOffset = new Insets2D.Double(0.0);

    protected void drawBackground(DrawingContext context) {
        Paint paint = this.getBackground();
        if (paint != null) {
            GraphicsUtils.fillPaintedShape(context.getGraphics(), this.getBounds(), paint, null);
        }
    }

    protected void drawBorder(DrawingContext context) {
        Stroke stroke = this.getBorderStroke();
        if (stroke != null) {
            Paint borderColor = this.getBorderColor();
            GraphicsUtils.drawPaintedShape(context.getGraphics(), this.getBounds(), borderColor, null, stroke);
        }
    }

    protected abstract void drawPlot(DrawingContext var1);

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.borderStroke = (Stroke)SerializationUtils.unwrap((Serializable)in.readObject());
    }

    private void writeObject(ObjectOutputStream out) throws ClassNotFoundException, IOException {
        out.defaultWriteObject();
        out.writeObject(SerializationUtils.wrap(this.borderStroke));
    }

    public Font getBaseFont() {
        return this.baseFont;
    }

    public void setBaseFont(Font baseFont) {
        this.baseFont = baseFont;
    }

    public Paint getBackground() {
        return this.background;
    }

    public void setBackground(Paint background) {
        this.background = background;
    }

    public Stroke getBorderStroke() {
        return this.borderStroke;
    }

    public void setBorderStroke(Stroke stroke) {
        this.borderStroke = stroke;
    }

    public Paint getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Paint color) {
        this.borderColor = color;
    }

    public Insets2D getClippingOffset() {
        return this.clippingOffset;
    }

    public void setClippingArea(Insets2D offset) {
        this.clippingOffset = offset;
    }
}

