/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.io.plots;

import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.io.IOCapabilities;
import de.erichseifert.gral.io.IOCapabilitiesStorage;
import de.erichseifert.gral.io.plots.DrawableWriter;
import de.erichseifert.gral.util.Messages;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class BitmapWriter
extends IOCapabilitiesStorage
implements DrawableWriter {
    private final String mimeType;
    private final int rasterFormat;

    protected BitmapWriter(String mimeType) {
        boolean isGrayscaleSupported;
        this.mimeType = mimeType;
        boolean isAlphaSupported = "image/png".equals(mimeType);
        boolean isColorSupported = !"image/vnd.wap.wbmp".equals(mimeType);
        boolean bl = isGrayscaleSupported = !"image/vnd.wap.wbmp".equals(mimeType);
        this.rasterFormat = isColorSupported ? (isAlphaSupported ? 2 : 1) : (isGrayscaleSupported ? 10 : 12);
    }

    @Override
    public void write(Drawable d, OutputStream destination, double width, double height) throws IOException {
        this.write(d, destination, 0.0, 0.0, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Drawable d, OutputStream destination, double x, double y, double width, double height) throws IOException {
        BufferedImage image = new BufferedImage((int)Math.ceil(width), (int)Math.ceil(height), this.rasterFormat);
        Graphics2D imageGraphics = image.createGraphics();
        imageGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        imageGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        imageGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        imageGraphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        DrawingContext context = new DrawingContext(imageGraphics);
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByMIMEType(this.getMimeType());
        if (writers.hasNext()) {
            ImageWriter writer = writers.next();
            ImageOutputStream ios = ImageIO.createImageOutputStream(destination);
            writer.setOutput(ios);
            Rectangle2D boundsOld = d.getBounds();
            d.setBounds(x, y, width, height);
            try {
                d.draw(context);
                writer.write(image);
            }
            finally {
                d.setBounds(boundsOld);
                ios.close();
            }
        }
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    static {
        BitmapWriter.addCapabilities(new IOCapabilities("BMP", Messages.getString("ImageIO.bmpDescription"), "image/bmp", new String[]{"bmp", "dib"}));
        BitmapWriter.addCapabilities(new IOCapabilities("GIF", Messages.getString("ImageIO.gifDescription"), "image/gif", new String[]{"gif"}));
        BitmapWriter.addCapabilities(new IOCapabilities("JPEG/JFIF", Messages.getString("ImageIO.jpegDescription"), "image/jpeg", new String[]{"jpg", "jpeg", "jpe", "jif", "jfif", "jfi"}));
        BitmapWriter.addCapabilities(new IOCapabilities("PNG", Messages.getString("ImageIO.pngDescription"), "image/png", new String[]{"png"}));
        BitmapWriter.addCapabilities(new IOCapabilities("WBMP", Messages.getString("ImageIO.wbmpDescription"), "image/vnd.wap.wbmp", new String[]{"wbmp"}));
    }
}

