/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.io.data;

import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.io.IOCapabilities;
import de.erichseifert.gral.io.data.AbstractDataReader;
import de.erichseifert.gral.util.Messages;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.imageio.ImageIO;

public class ImageReader
extends AbstractDataReader {
    public ImageReader(String mimeType) {
        super(mimeType);
        this.setDefault("factor", 1.0);
        this.setDefault("offset", 0.0);
    }

    @Override
    public DataSource read(InputStream input, Class<? extends Comparable<?>> ... types) throws IOException {
        BufferedImage image = ImageIO.read(input);
        int w = image.getWidth();
        int h = image.getHeight();
        Object[] colTypes = new Class[w];
        Arrays.fill(colTypes, Double.class);
        DataTable data = new DataTable((Class<? extends Comparable<?>>[])colTypes);
        double factor = ((Number)this.getSetting("factor")).doubleValue();
        double offset = ((Number)this.getSetting("offset")).doubleValue();
        int[] pixelData = new int[w];
        Double[] rowData = new Double[w];
        for (int y = 0; y < h; ++y) {
            image.getRGB(0, y, pixelData.length, 1, pixelData, 0, 0);
            for (int x = 0; x < pixelData.length; ++x) {
                double r = pixelData[x] >> 16 & 0xFF;
                rowData[x] = r * factor + offset;
            }
            data.add(rowData);
        }
        return data;
    }

    static {
        ImageReader.addCapabilities(new IOCapabilities("BMP", Messages.getString("ImageIO.bmpDescription"), "image/bmp", new String[]{"bmp", "dib"}));
        ImageReader.addCapabilities(new IOCapabilities("GIF", Messages.getString("ImageIO.gifDescription"), "image/gif", new String[]{"gif"}));
        ImageReader.addCapabilities(new IOCapabilities("JPEG/JFIF", Messages.getString("ImageIO.jpegDescription"), "image/jpeg", new String[]{"jpg", "jpeg", "jpe", "jif", "jfif", "jfi"}));
        ImageReader.addCapabilities(new IOCapabilities("PNG", Messages.getString("ImageIO.pngDescription"), "image/png", new String[]{"png"}));
        ImageReader.addCapabilities(new IOCapabilities("WBMP", Messages.getString("ImageIO.wbmpDescription"), "image/vnd.wap.wbmp", new String[]{"wbmp"}));
    }
}

