/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.io;

import de.erichseifert.gral.io.IOCapabilities;
import de.erichseifert.gral.io.IOFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class AbstractIOFactory<T>
implements IOFactory<T> {
    private final Map<String, Class<? extends T>> entries = new HashMap<String, Class<? extends T>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractIOFactory(String propFileName) throws IOException {
        Enumeration<URL> propFiles = this.getClass().getClassLoader().getResources(propFileName);
        if (!propFiles.hasMoreElements()) {
            throw new IOException(MessageFormat.format("Property file not found: {0}", propFileName));
        }
        Properties props = new Properties();
        while (propFiles.hasMoreElements()) {
            URL propURL = propFiles.nextElement();
            try (InputStream stream = null;){
                stream = propURL.openStream();
                props.load(stream);
            }
            for (Map.Entry<Object, Object> prop : props.entrySet()) {
                Class<?> clazz;
                String mimeType = (String)prop.getKey();
                String className = (String)prop.getValue();
                try {
                    clazz = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e);
                }
                this.entries.put(mimeType, clazz);
            }
        }
    }

    @Override
    public IOCapabilities getCapabilities(String mimeType) {
        Class<T> clazz = this.entries.get(mimeType);
        try {
            Method capabilitiesGetter = clazz.getMethod("getCapabilities", new Class[0]);
            Set capabilities = (Set)capabilitiesGetter.invoke(clazz, new Object[0]);
            for (IOCapabilities c : capabilities) {
                if (!c.getMimeType().equals(mimeType)) continue;
                return c;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public List<IOCapabilities> getCapabilities() {
        ArrayList<IOCapabilities> caps = new ArrayList<IOCapabilities>(this.entries.size());
        for (String mimeType : this.entries.keySet()) {
            IOCapabilities capability = this.getCapabilities(mimeType);
            if (capability == null) continue;
            caps.add(capability);
        }
        return caps;
    }

    @Override
    public String[] getSupportedFormats() {
        String[] formats = new String[this.entries.size()];
        this.entries.keySet().toArray(formats);
        return formats;
    }

    @Override
    public boolean isFormatSupported(String mimeType) {
        return this.entries.containsKey(mimeType);
    }

    protected Class<? extends T> getTypeClass(String type) {
        return this.entries.get(type);
    }

    @Override
    public T get(String mimeType) {
        return null;
    }
}

